//=============================================================================
// counts down on a timer. Only one countdown at a time plz
//=============================================================================
class countdown extends Window
	transient;

// ----------------------------------------------------------------------
// Local Variables
// ----------------------------------------------------------------------

var countdowntrigger CDT;

var String message;
var int    charIndex;

var Font       fontText;
var TextWindow winText;
var TextWindow winTextShadow;

var Int        shadowDist;
var Float      displayTime;
var Int        maxTextWidth;

var Color colText;
var Color colBlack;

// ----------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	winTextShadow = TextWindow(NewChild(Class'TextWindow'));
	winTextShadow.SetFont(fontText);
	winTextShadow.SetTextColor(colBlack);
	winTextShadow.SetTextMargins(0, 0);
	winTextShadow.SetTextAlignments(HALIGN_Left, VALIGN_Top);

	winText = TextWindow(NewChild(Class'TextWindow'));
	winText.SetFont(fontText);
	winText.SetTextColor(colText);
	winText.EnableTranslucentText(True);
	winText.SetTextMargins(0, 0);
	winText.SetTextAlignments(HALIGN_Left, VALIGN_Top);
}


function string converttotime(float time)
{
local float seconds;
local float minutes;

local string strseconds;
local string strminutes;

minutes = int(time/60);
seconds = int(time) - 60 * minutes;

strseconds = left(string(seconds),2);
strminutes = left(string(minutes),2);

if (seconds < 10)
	strseconds = " " $ left(strseconds,1);
if (minutes < 10)
	strminutes = " " $ left(strminutes,1);

return strminutes $ ":" $ strseconds;
}

// ----------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------

function Tick(float deltaTime)
{

		displayTime -= deltaTime;

		if (displayTime <= 0)
		{
			CDT.countdownover();			
			bTickEnabled = False;
			HideMessage();
		}
winText.Settext(converttotime(displaytime));

}

// ----------------------------------------------------------------------
// HideMessage()
// ----------------------------------------------------------------------

function HideMessage()
{
	Hide();
}

// ----------------------------------------------------------------------
// ParentRequestedPreferredSize() 
// ----------------------------------------------------------------------

event ParentRequestedPreferredSize(bool bWidthSpecified, out float preferredWidth,
                                   bool bHeightSpecified, out float preferredHeight)
{
	local GC gc;

	gc = GetGC();

	gc.SetFont(fontText);
	gc.GetTextExtent(maxTextWidth, preferredWidth, preferredHeight, converttotime(displaytime));

	preferredWidth  += shadowDist;
	preferredHeight += shadowDist;

	ReleaseGC(gc);
}

// ----------------------------------------------------------------------
// ConfigurationChanged()
//
// Set the size of stuff and stuff.
// ----------------------------------------------------------------------

function ConfigurationChanged()
{

	winText.ConfigureChild(0, 0, width, height);
	winTextShadow.ConfigureChild(shadowDist, shadowDist, width, height);
}

// ----------------------------------------------------------------------
// ChildRequestedReconfiguration()
// ----------------------------------------------------------------------

event bool ChildRequestedReconfiguration(window childWin)
{
	return False;
}

// ----------------------------------------------------------------------
// StartMessage()
// ----------------------------------------------------------------------

function StartMessage()
{
	Show();
	AskParentForReconfigure();
	bTickEnabled = True;
}

function settime(float time)
{
displaytime = time;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     fontText=Font'DeusExUI.FontLocation'
     shadowDist=2
     maxTextWidth=500
     colText=(R=255,G=255,B=255)
}
