//=============================================================================
// PersonaScreenLogs
//=============================================================================

class informationwindow extends PersonaScreenBaseWindow;

var personatitletextwindow titlescreen;

var MenuUINormalLargeTextWindow winINFO;
var PersonaScrollAreaWindow   winScroll;

var localized String LogsTitleText;
var localized string ClearButtonLabel;
var name source;
var string sourcepackage;

var Texture CreditsBannerTextures[6];

function reread()
{
ProcessDeusExText(source, winINFO);
}


function string fillstring()
{
local int a;
local string s;
for (a=1;a<256;a++)
{
s = s $ chr(a);
}
return s;
}

function string processbold(string s)
{
local string characters[999];
local int num;
local bool bbold;
local string tag;
local int a;
local int b;

num = 0;

while(s != "")
{
num = num + 1;
characters[num] = left(s,1);
s = right(s, len(s) - 1);
}

s = "";
num++;

for (b=1;b<=num;b++)
{
	if (characters[b] == "{")
		bbold = true;
	else if (characters[b] == "}")
		bbold = false;
	else
		if ((bbold) && (characters[b] != " "))
			s = s $ chr(asc(characters[b]) + 128);
		else
			s = s $ characters[b];

}
return s;
}

// ----------------------------------------------------------------------
// PrintPicture()
// ----------------------------------------------------------------------

function PrintPicture(
	Texture pictureTextures[6], 
	int textureCols,
	int textureRows,
	int imageX, 
	int imageY)
{
	local PictureWindow winPicture;

	winPicture = PictureWindow(winScroll.NewChild(Class'PictureWindow'));
	winPicture.SetTextures(pictureTextures, textureCols, textureRows);
	winPicture.SetSize(imageX, imageY);
}

// ----------------------------------------------------------------------
// ProcessDeusExText()
// ----------------------------------------------------------------------

function ProcessDeusExText(Name textName, optional TextWindow winText)
{
	local DeusExTextParser parser;
	local string TextPackage;
	local int a;

	// First check to see if we have a name
	if ( textName != '' )
	{
		// Create the text parser
		parser = new(None) Class'DeusExTextParser';
		parser.SetPlayerName(player.TruePlayerName);

		if (sourcepackage != "")
			textpackage = sourcepackage;
		else
			TextPackage = "DeusExText";

		// Attempt to find the text object
		if ( parser.OpenText(textName, TextPackage) )
		{
			while(parser.ProcessText())
			{
					ProcessDeusExTextTag(parser, winText);
			}


			//wintext.setfont(font'tnm.trestkonsfont'); //TODO - wtf was this doing?
			parser.CloseText();
		}

		CriticalDelete(parser);
	}
}

// ----------------------------------------------------------------------
// ProcessDeusExTextTag()
// ----------------------------------------------------------------------

function ProcessDeusExTextTag(DeusExTextParser parser, optional TextWindow winText)
{

	local String text;
//	local EDeusExTextTags tag;
	local byte tag;
	local Name fontName;
	local String textPart;
	local int a;

	tag  = parser.GetTag();
	//wintext.setfont(font'tnm.trestkonsfont'); //TODO - again wtf is this doing

	switch(tag)
	{
		case 0:				// TT_Text:
		case 9:				// TT_PlayerName:
		case 10:			// TT_PlayerFirstName:
			text = parser.GetText();

			// Add the text
			if (winText != None)
				winText.AppendText(processbold(text));
			break;

		case 1:				// TT_File
			ProcessFile(parser);
			break;

		case 2:				// TT_Email
			ProcessEmail(parser);
			break;

		case 18:			// TT_NewParagraph:
			if (winText != None)
				winText.AppendText(CR());
			break;

		case 13:				// TT_LeftJustify:
			break;

		case 14:			// TT_RightJustify:
			break;

		case 12:				// TT_CenterText:
			break;
		case 19:			//bold
			text = parser.GetText();

			// Add the text
			if (winText != None)
				winText.AppendText(processbold(text));
			break;

		case 26:			// TT_Font:
			break;

		case 15:			// TT_DefaultColor:
		case 16:			// TT_TextColor:
		case 17:			// TT_RevertColor:
			break;
	}
}

function ProcessFile(DeusExTextParser parser)
{
}
function ProcessEmail(DeusExTextParser parser)
{
}



// ----------------------------------------------------------------------
// CreateinfoWindow()
// ----------------------------------------------------------------------

function CreateinfoWindow()
{
	winScroll = CreateScrollAreaWindow(winclient);
	winScroll.SetPos(13, 19);
	winScroll.SetSize(397, 364);

	winINFO=MenuUINormalLargeTextWindow(winScroll.ClipWindow.NewChild(Class'MenuUINormalLargeTextWindow'));
	winINFO.SetTextMargins(4, 1);
	winINFO.SetWordWrap(True);
	winINFO.SetTextAlignments(HALIGN_Left, VALIGN_Top);
}

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	local int a;
	Super.InitWindow();

	EnableButtons();

	wininfo.SetText("");
}

// ----------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;

	if ( Super.ButtonActivated( buttonPressed ) )
		return True;

	bHandled   = True;

	switch( buttonPressed )
	{
		default:
			bHandled = False;
			break;
	}

	return bHandled;
}


// ----------------------------------------------------------------------
// CreateControls()
// ----------------------------------------------------------------------

function CreateControls()
{
	CreateClientBorderWindow();
	CreateClientWindow();

	titlescreen = CreateTitleWindow(9, 5, LogsTitleText);
	CreateButtons();
	createinfowindow();
}

// ----------------------------------------------------------------------
// CreateButtons()
// ----------------------------------------------------------------------

function CreateButtons()
{
	local PersonaButtonBarWindow winActionButtons;

	winActionButtons = PersonaButtonBarWindow(winClient.NewChild(Class'PersonaButtonBarWindow'));
	winActionButtons.SetPos(10, 385);
	winActionButtons.SetWidth(75);
}

// ----------------------------------------------------------------------
// EnableButtons()
// ----------------------------------------------------------------------

function EnableButtons()
{

}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     LogsTitleText="Logs"
     ClearButtonLabel="Cl|&ear Log"
     CreditsBannerTextures(0)=Texture'DeusExUI.UserInterface.CreditsBanner_1'
     CreditsBannerTextures(1)=Texture'DeusExUI.UserInterface.CreditsBanner_2'
     ClientWidth=426
     ClientHeight=407
     clientOffsetX=105
     clientOffsetY=17
     clientTextures(0)=Texture'DeusExUI.UserInterface.LogsBackground_1'
     clientTextures(1)=Texture'DeusExUI.UserInterface.LogsBackground_2'
     clientTextures(2)=Texture'DeusExUI.UserInterface.LogsBackground_3'
     clientTextures(3)=Texture'DeusExUI.UserInterface.LogsBackground_4'
     clientBorderTextures(0)=Texture'DeusExUI.UserInterface.ConversationsBorder_1'
     clientBorderTextures(1)=Texture'DeusExUI.UserInterface.ConversationsBorder_2'
     clientBorderTextures(2)=Texture'DeusExUI.UserInterface.ConversationsBorder_3'
     clientBorderTextures(3)=Texture'DeusExUI.UserInterface.ConversationsBorder_4'
     clientBorderTextures(4)=Texture'DeusExUI.UserInterface.ConversationsBorder_5'
     clientBorderTextures(5)=Texture'DeusExUI.UserInterface.ConversationsBorder_6'
     clientTextureRows=2
     clientTextureCols=2
     clientBorderTextureRows=2
     clientBorderTextureCols=3
}
