//=============================================================================
// tnmATM
// Smoke39 - implementing persistent, cross-level account info
//=============================================================================
class tnmATM extends ATM;

var Trestkon Trest;
var int hackIndex;

var class<ATMWindow> winClass;
var string winClassStr;

var() bool bOutOfOrder;

var ParticleGenerator sparkGen;

var() localized string outOfOrderMsg;

function InitGenerator()
{
	local Vector loc;

	if ((sparkGen == None) || (sparkGen.bDeleteMe))
	{
		loc = Location;
		sparkGen = Spawn(class'ParticleGenerator', Self,, loc, rotation);
		if (sparkGen != None)
			sparkGen.SetBase(Self);
	}
}

function UpdateOutOfOrder()
{
	if (bOutOfOrder)
		SetTimer(1.0, True);
	else
		SetTimer(1.0,False);
}


function prebeginplay()
{
	winClass=class<ATMWindow>(DynamicLoadObject(winClassStr, class'Class'));
	UpdateOutOfOrder();
	super.PreBeginPlay();
}

function Timer()
{
	if (boutoforder)
	{
	if (frand() < 0.2)
	{
		InitGenerator();
		if (sparkGen != None)
		{
			sparkGen.particleLifeSpan = 0.4;
			sparkGen.particleTexture = Texture'Effects.Fire.SparkFX1';
			sparkGen.particleDrawScale = 0.05;
			sparkGen.bRandomEject = True;
			sparkGen.ejectSpeed = 100.0;
			sparkGen.bGravity = True;
			sparkGen.bParticlesUnlit = True;
			sparkGen.frequency = 0.2;
			sparkGen.riseRate = 10;
			sparkGen.spawnSound = Sound'Spark2';
		}
	}
	}
}

function Frob( Actor Frobber, Inventory frobWith )
{
	local DeusExPlayer Player;
	local DeusExRootWindow root;
	local float elapsed, delay;

	// remember who frobbed us, 'cause he's got all the data
	Trest = Trestkon(Frobber);

	if (bOutOfOrder)
	{
		Trest.ClientMessage(outOfOrderMsg);
		return;
	}

	// figure out what account should be hacked
	PickHackIndex();

	Super(ElectronicDevices).Frob(Frobber, frobWith);

	// if we're already using this ATM, get out
	if (atmwindow != None)
		return;

	Player = DeusExPlayer(Frobber);

	if (Player != None)
	{
		if (bLockedOut)
		{
			// computer skill shortens the lockout duration
			delay = lockoutDelay / Player.SkillSystem.GetSkillLevelValue(class'SkillComputer');

			elapsed = Level.TimeSeconds - lockoutTime;
			if (elapsed < delay)
				Player.ClientMessage(Sprintf(msgLockedOut, Int(delay - elapsed)));
			else
				bLockedOut = False;
		}
		if (!bLockedOut)
		{
			root = DeusExRootWindow(Player.rootWindow);
			if (root != None)
			{
				atmWindow = ATMWindow(root.InvokeUIScreen(winClass, True));

				if (atmWindow != None)
				{
					atmWindow.SetCompOwner(Self);
					atmWindow.ShowFirstScreen();
				}
			}
		}
	}
}

function int NumUsers()
{
	local int i;

	for ( i=0; i<ArrayCount(Trest.userList); i++ )
	{
		if ( Trest.userList[i].accountNumber == "" )
			break;
	}

	return i;
}

function int GetBalance( int userIndex, float mod )
{
	if ( userIndex == -1 )
		return Trest.userList[hackIndex].balance * mod;

	if ( userIndex >= 0 && userIndex < ArrayCount(Trest.userList) )
		return Trest.userList[userIndex].balance;
}

function ModBalance( int userIndex, int numCredits, bool bSync )
{
	if ( userIndex == -1 )
		Trest.userList[hackIndex].balance = 0;
	else if ( userIndex >= 0 && userIndex < ArrayCount(Trest.userList) )
	{
		Trest.userList[userIndex].balance -= numCredits;

		// if we just legitimately emptied the first unempty account
		// find the next hack candidate
		if ( userIndex == hackIndex && Trest.userList[userIndex].balance < 1 )
			PickHackIndex();
	}
}

function PickHackIndex()
{
	// go for the first unempty account
	for ( hackIndex=0; hackIndex<ArrayCount(Trest.userList); hackIndex++ )
	{
		if ( Trest.userList[hackIndex].balance > 0 )
			break;
	}
}

function string GetAccountNumber( int userIndex )
{
	if ( userIndex == -1 )
		return "HACKED";
	else if ( userIndex >= 0 && userIndex < ArrayCount(Trest.userList) )
		return Caps( Trest.userList[userIndex].accountNumber );

	return "ERR";
}

function string GetPIN( int userIndex )
{
	if ( userIndex == -1 )
		return "HACKED";
	else if ( userIndex >= 0 && userIndex < ArrayCount(Trest.userList) )
		return Caps( Trest.userList[userIndex].PIN );

	return "ERR";
}

defaultproperties
{
     outOfOrderMsg="This ATM appears to be out of order"
     winClassStr="TNMGUI.tnmATMWindow"
}
