//=============================================================================
// AugDefense.
//=============================================================================
class tnmAugDefense extends tnmAugmentation;

state Active
{
	function Timer()
	{
		local DeusExProjectile minproj;
		local float mindist;

		minproj = FindNearestProjectile();

		if (minproj != None)
		{
			mindist = VSize(TNMP.Location - minproj.Location);

			if (mindist < Value)
			{				
				minproj.bAggressiveExploded=True;
				minproj.Explode(minproj.Location, vect(0,0,1));
				TNMP.PlaySound(sound'ProdFire', SLOT_None,,,, 2.0);
			}
		}
	}

Begin:
	SetTimer(0.1, True);
}

function Deactivate()
{
	Super.Deactivate();

	SetTimer(0.1, False);
}

function DeusExProjectile FindNearestProjectile()
{
   local DeusExProjectile proj, minproj;
   local float dist, mindist;
   local bool bValidProj;

   minproj = None;
   mindist = 999999;
   foreach AllActors(class'DeusExProjectile', proj)
   {
         bValidProj = (!proj.bStuck) && (!proj.bIgnoresNanoDefense);

      if (bValidProj)
      {
         if (proj.Owner != TNMP)
         {
		if (VSize(proj.Velocity) > 100)
		{
		   dist = VSize(TNMP.Location - proj.Location);
		   if (dist < mindist)
		   {
			  mindist = dist;
			  minproj = proj;
		   }
		}
         }
      }
   }

   return minproj;
}

defaultproperties
{
     Value=300.000000
     AugmentationName="Aggressive Defense"
}
