//=============================================================================
// AugLight.
//=============================================================================
class tnmAugLight extends AugLight;

var Beam beams[2];

simulated function float GetEnergyRate()
{
if (GetCurrentLevel() == 0)
	return 10.0;
else
        return 0.0;
}

simulated function bool UpdateInfo(Object winObject)
{
	local PersonaInfoWindow winInfo;
	local String strOut;

	winInfo = PersonaInfoWindow(winObject);
	if (winInfo == None)
		return False;

	winInfo.Clear();
	winInfo.SetTitle(AugmentationName);

	if (bUsingMedbot)
	{
		winInfo.SetText(Sprintf(OccupiesSlotLabel, AugLocsText[AugmentationLocation]));
		winInfo.AppendText(winInfo.CR() $ winInfo.CR() $ Description);
	}
	else
	{
		winInfo.SetText(Description);
	}

	// Energy Rate
	winInfo.AppendText(winInfo.CR() $ winInfo.CR() $ Sprintf(EnergyRateLabel, Int(GetEnergyRate())));

	// Current Level
	strOut = Sprintf(CurrentLevelLabel, CurrentLevel + 1);
	
	// Can Upgrade / Is Active labels
	if (CanBeUpgraded())
		strOut = strOut @ CanUpgradeLabel;
	else if (CurrentLevel == MaxLevel )
		strOut = strOut @ MaximumLabel;

	winInfo.AppendText(winInfo.CR() $ winInfo.CR() $ strOut);

	// Always Active?
	if (bAlwaysActive)
		winInfo.AppendText(winInfo.CR() $ winInfo.CR() $ AlwaysActiveLabel);

	return True;
}

// Smoke39 - test only for being below maxlevel instead of CanBeUpgraded()
// which also looks for an aug upgrade can because
// 1. it's unnecessary here
// 2. it prevents upgrading with a redundant aug can
function bool IncLevel()
{
	if ( CurrentLevel >= MaxLevel )
	{
		Player.ClientMessage(Sprintf(AugAlreadyHave, AugmentationName));
		return False;
	}

	if (bIsActive)
		Deactivate();

	CurrentLevel++;
				
	Player.ClientMessage(Sprintf(AugNowHave, AugmentationName, CurrentLevel + 1));
}


// Smoke39 - mostly redone, based on code from LaserEmitter and old AugLight

function PreTravel()
{
	super.pretravel();

	// make sure we destroy the light before we travel
	// Smoke39 - 'cause the Deus Ex people say so :O
	killbeam();
}

function SetBeamLocation()
{
	local vector StartTrace, EndTrace, HitLocation, HitNormal, Reflection;
	local actor target, HitActor;
	local int i, texFlags;
	local name texName, texGroup;
	local float range, dist, size, radius, brightness;
	local bool bBad;

	StartTrace = Player.Location;
	StartTrace.Z += Player.BaseEyeHeight;
	range = LevelValues[CurrentLevel];
	EndTrace = StartTrace + range * Vector(Player.ViewRotation);

	// trace the path of the reflected beam and draw points at each hit
	for (i=0; i<ArrayCount(beams); i++)
	{
		foreach TraceTexture(class'Actor', target, texName, texGroup, texFlags, HitLocation, HitNormal, EndTrace, StartTrace)
		{
			// drawn, unhidden, not invisible
			if ( target.DrawType != DT_None && !target.bHidden && (texFlags & 1) == 0 )
			{
				bBad = false;
				break;
			}
			else if ( target == Level || target.IsA('Mover') )
			{
				bBad = false;
				break;
			}
			else
				bBad = true;
		}

		// we hit nothing, run around screaming!
		if ( HitLocation == vect(0,0,0) || bBad )
			HitLocation = EndTrace;

		if (beams[i] == None)
		{
			beams[i] = Spawn( class'beam', Player, '', HitLocation );
			beams[i].LightHue = 32;
			beams[i].LightSaturation = 140;
		}
		else
			beams[i].SetLocation( HitLocation );

		// make sure it's awake
		beams[i].bStasis = false;
		beams[i].bForceStasis = false;

		dist      += VSize(HitLocation - StartTrace);
		size       = fclamp(dist/LevelValues[CurrentLevel], 0, 1);
		radius     = size*8.12 + 1.0;  // size*5.12 + 4.0;
		brightness = fclamp(size-0.5, 0, 1)*2*-192 + 192;
		beams[i].LightRadius     = byte(radius);
		beams[i].LightBrightness = byte(brightness);  // someday we should put this back in again   Smoke39 - I just did.
		beams[i].LightType       = LT_Steady;

		// end of the line
		if ( range - dist < 1 )
		{
			killpast(i);
			return;
		}

		// mirror
		if ( (texFlags & 0x08000000) != 0 )
		{
			Reflection = MirrorVectorByNormal(Normal(HitLocation - StartTrace), HitNormal);
			StartTrace = HitLocation + HitNormal;
			EndTrace = StartTrace + Reflection * (range-Dist);
			HitLocation = vect(0,0,0);
		}
		// translucent, masked
		else if ( (texFlags & 0x00000004) != 0 || (texFlags & 0x00000002) != 0 )
		{
			StartTrace = HitLocation - 10 * HitNormal;
			HitLocation = vect(0,0,0);
		}
		// opaque
		else
		{
			killpast(i);
			return;
		}
	}
}

// Smoke39 - lyke, omg, wat cud it do?!
function killbeam()
{
	local int i;

	for ( i=0; i<ArrayCount(beams); i++ )
	{
		if ( beams[i] != None )
		{
			beams[i].Destroy();
			beams[i] = None;
		}
	}
}

// Smoke39 - kill beams past that at index i
function killpast( int i )
{
	if (i < ArrayCount(beams)-1)
	{
		do
		{
			i++;
			if (beams[i] != None)
			{
				beams[i].Destroy();
				beams[i] = None;
			}
		} until (i>=ArrayCount(beams)-1);
	}
}

function Deactivate()
{
	Super.Deactivate();

	killbeam();
}

state Active
{
	function Tick (float deltaTime)
	{
		SetBeamLocation();
		SetGlowLocation();
	}
	
	function BeginState()
	{
		Super(augmentation).BeginState();

		SetBeamLocation();

		b2 = Spawn(class'Beam', Player, '', Player.Location);
		if (b2 != None)
		{
			b2.LightHue = 32;
			b2.LightRadius = 4;
			b2.LightSaturation = 140;
			b2.LightBrightness = 220;
			SetGlowLocation();
		}
	}

Begin:
}

defaultproperties
{
     MaxLevel=1
     Description="Bioluminescent cells within the retina provide coherent illumination of the agent's field of view. With the latest generation of this technology, the cells can be powered solely by intraocular vibrations, eliminating the need for bioelectric energy.|n|nTECH ONE: Small energy drain.|n|nTECH TWO: No energy drain."
     LevelValues(1)=1024.000000
}
