//=============================================================================
// tnmComputers.
//=============================================================================
class tnmComputers extends Computers;

//game stuff -Shacker
enum TNM2DGameType
{
TNM2D_None,
TNM2D_Pong,
TNM2D_Tetris,
TNM2D_Breakout,
TNM2D_LightsOut,
TNM2D_TextGame,
TNM2D_IRC,
TNM2D_FakeIRC,
TNM2D_DXIGame,
};
var() bool bHasGames;
var() TNM2DGameType games[5];
//end game stuff

var() name AttachedPrinter;

var() bool bBlackIce;
var() bool bNarcissus;
var() name NarcissusFlag;
var() bool bUsable;

var string terminalTypeStr;

struct sSpecialOptionflag
{
	var() name SpecialOptionFlag;
	var() bool bDesiredValue;
	var() bool bVisibleInactive;
};

struct sSpecialOptionlogout
{
	var() bool bLogout;
};

var(Computers) localized sSpecialOptionflag specialOptionflags[4];
var(Computers) sSpecialOptionlogout specialOptionLogout[4];

enum EComputerNodesNEW
{
CN_WCNet,
CN_WCID, //WC Intelligence Department,
CN_PDXNet,
CN_DXO, //DeusEx.org,
CN_MelkNett, //MelkNett(TM),
CN_DXI, //Deus Ex Incarnate,
CN_ABI, //Aunt Betty Industries,
CN_BettyTech,
CN_GameSpy,
CN_DXE, // DXEditing
CN_BOS, // BlueOS (non-networked)
CN_QuickStop //From Deusex
};

var() EComputerNodesNEW ComputerNodeNEW;

event PreBeginPlay()
{
	if(terminalTypeStr!="")
		terminalType=class<NetworkTerminal>(DynamicLoadObject(terminalTypeStr, class'Class'));
}

function printer GetPrinter()
{
	local printer p;
	if(AttachedPrinter=='')
		return None;
	foreach AllActors(class'printer', p , AttachedPrinter)
		break;
	return p;
}

// ----------------------------------------------------------------------
// GetNodeName()
// ----------------------------------------------------------------------

function String GetNodeName()
{
	return nodeInfo[Int(ComputerNodeNEW)].nodeName;
}

// ----------------------------------------------------------------------
// GetNodeDesc()
// ----------------------------------------------------------------------

function String GetNodeDesc()
{
	return nodeInfo[Int(ComputerNodeNEW)].nodeDesc;
}

// ----------------------------------------------------------------------
// GetNodeAddress()
// ----------------------------------------------------------------------

function String GetNodeAddress()
{
	return nodeInfo[Int(ComputerNodeNEW)].nodeAddress;
}

// ----------------------------------------------------------------------
// GetNodeTexture()
// ----------------------------------------------------------------------

function Texture GetNodeTexture()
{
	return nodeInfo[Int(ComputerNodeNEW)].nodeTexture;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function clean()
{
	if ((termwindow.winComputer.winStatus != None) && (termwindow.winComputer.compOwner.IsA('Computers')))
		termwindow.winComputer.winStatus.SetText(tnmComputers(termwindow.winComputer.compOwner).GetNodeAddress());
}

function Frob(Actor Frobber, Inventory frobWith)
{
	if(!bUsable)
	{
		Trestkon(Frobber).ClientMessage("This machine is being used by someone else.");
		return;
	}

	super.Frob(Frobber,frobWith);
}

defaultproperties
{
     specialOptionflags(0)=(bDesiredValue=True)
     specialOptionflags(1)=(bDesiredValue=True)
     specialOptionflags(2)=(bDesiredValue=True)
     specialOptionflags(3)=(bDesiredValue=True)
     TextPackage="tnmText"
     NodeInfo(0)=(nodeName="WCNet",nodeDesc="WCNet",nodeAddress="Narcissus:GlobalNode:GameSpy//WCNET//NODE.34@778/Login",nodeTexture=Texture'TNM.Nodes.NodeWC')
     NodeInfo(1)=(nodeName="WCID",nodeDesc="WC Intelligence Department",nodeAddress="Narcissus:GlobalNode:GameSpy//WCNET//NODE.34@778/Login",nodeTexture=Texture'TNM.Nodes.NodeWCID')
     NodeInfo(2)=(nodeName="PDXNet",nodeDesc="PDXNet",nodeAddress="Narcissus:GlobalNode:GameSpy//PDXNET//NODE.65@435/Login",nodeTexture=Texture'TNM.Nodes.NodePDX')
     NodeInfo(3)=(nodeName="DeusEx.org",nodeDesc="DeusEx.org",nodeAddress="Narcissus:GlobalNode:GameSpy//DXO//NODE.13@468/Login",nodeTexture=Texture'TNM.Nodes.NodeDXO')
     NodeInfo(4)=(nodeName="MelkNett(TM)",nodeDesc="MelkNett(TM)",nodeAddress="Narcissus:GlobalNode:GameSpy//MELKNET//NODE.78@793/Login",nodeTexture=Texture'TNM.Nodes.Nodemelknett')
     NodeInfo(5)=(nodeName="Deus Ex Incarnate",nodeDesc="Deus Ex Incarnate",nodeAddress="Narcissus:GlobalNode:GameSpy//DXI//NODE.44@156/Login",nodeTexture=Texture'TNM.Nodes.NodeDXI')
     NodeInfo(6)=(nodeName="Aunt Betty Industries",nodeDesc="Aunt Betty Industries",nodeAddress="Narcissus:GlobalNode:GameSpy//ABI//NODE.69@235/Login",nodeTexture=Texture'TNM.Nodes.NodeABI')
     NodeInfo(7)=(nodeName="Aunt Betty Technologies",nodeDesc="Aunt Betty Technologies",nodeAddress="Narcissus:GlobalNode:GameSpy//ABI//NODE.69@235/Login",nodeTexture=Texture'TNM.Nodes.NodeBettyTech')
     NodeInfo(8)=(nodeName="GameSpy",nodeDesc="GameSpy",nodeAddress="Narcissus:GlobalNode:GameSpy//GS//NODE.22@756/Login",nodeTexture=Texture'TNM.Nodes.NodeGS')
     NodeInfo(9)=(nodeName="DXEditing",nodeDesc="DXEditing",nodeAddress="Narcissus:GlobalNode:GameSpy//DXE//NODE.89@274/Login",nodeTexture=Texture'TNM.Nodes.NodeDXE')
     NodeInfo(10)=(nodeName="BlueOS",nodeDesc="Local Machine (no network detected)",nodeAddress="LocalMachine//system/bluekernel/interface/Login",nodeTexture=Texture'TNM.Nodes.NodeBOS')
     NodeInfo(11)=(nodeName="Quick Stop",nodeDesc="Quick Stop",nodeAddress="Narcissus:GlobalNode:GameSpy//QUICKSTOP//NODE.77@081/Login",nodeTexture=Texture'DeusExUI.UserInterface.ComputerLogonLogoQuickStop')
     bUsable=True
}
