//=============================================================================
// HUDObjectBelt
//=============================================================================
class tnmHUDObjectBelt expands HUDObjectBelt;

// ----------------------------------------------------------------------
// CreateSlots()
//
// Creates the Slots 
// ----------------------------------------------------------------------

function CreateSlots()
{
	local int i;
	local RadioBoxWindow winRadio;

	// Radio window used to contain objects so they can be selected
	// with the mouse on the inventory screen.

	winRadio = RadioBoxWindow(NewChild(Class'RadioBoxWindow'));
	winRadio.SetSize(504, 54);
	winRadio.SetPos(10, 6);
	winRadio.bOneCheck = False;

	winSlots = TileWindow(winRadio.NewChild(Class'TileWindow'));
	winSlots.SetMargins(0, 0);
	winSlots.SetMinorSpacing(0);
	winSlots.SetOrder(ORDER_LeftThenUp);

	for (i=0; i<10; i++)
	{
		objects[i] = HUDObjectSlot(winSlots.NewChild(Class'tnmHUDObjectSlot'));
		objects[i].SetObjectNumber(i);
		objects[i].Lower();

		// Last item is a little shorter
		if ( i == 0 )
			objects[i].SetWidth(44);
	}
	objects[0].Lower();

}

defaultproperties
{
}
