//=============================================================================
// HUDObjectSlot
//=============================================================================
class tnmHUDObjectSlot expands HUDObjectSlot;

// ----------------------------------------------------------------------
// UpdateItemText()
// ----------------------------------------------------------------------

function UpdateItemText()
{
	local DeusExWeapon weapon;
	local tnmweapon Tweapon;

	itemText = "";

	if (item != None)
	{
		if (item.IsA('DeusExWeapon'))
		{
			// If this is a weapon, show the number of remaining rounds 
			weapon = DeusExWeapon(item);

			// Ammo loaded
			if ((weapon.AmmoName != class'AmmoNone') && (!weapon.bHandToHand) && (weapon.ReloadCount != 0) && (weapon.AmmoType != None))
			{
				Tweapon = tnmweapon(weapon);
				if ((Tweapon != none)&&(Tweapon.busefiremode))
					itemText = Tweapon.belttext;
				else
					itemText = weapon.AmmoType.beltDescription;
			}

			// If this is a grenade
			if (weapon.IsA('WeaponNanoVirusGrenade') || 
				weapon.IsA('WeaponGasGrenade') || 
				weapon.IsA('WeaponEMPGrenade') ||
				weapon.IsA('WeaponLAM'))
			{
				if (weapon.AmmoType.AmmoAmount > 1)
					itemText = CountLabel @ weapon.AmmoType.AmmoAmount;
			}

		}
		else if (item.IsA('DeusExPickup') && (!item.IsA('NanoKeyRing')))
		{
			// If the object is a SkilledTool (but not the NanoKeyRing) then show the 
			// number of uses
			if (DeusExPickup(item).NumCopies > 1)
				itemText = DeusExPickup(item).CountLabel @ String(DeusExPickup(item).NumCopies);
		}
	}
}

defaultproperties
{
}
