class tnmMission25 expands TNMMissionScript;

var localized string endgameQuote[10];
var float endgameDelays[5];
var byte savedSoundVolume;

function StartConversationByName(Name conName, Actor conOwner, optional bool bAvoidState, optional bool bForcePlay)
{
	local bool bsuccess;
	bsuccess = player.StartConversationByName(conName, conOwner, bAvoidState, bForcePlay);
	if (!bsuccess)
		Log("Failed to play conversation");
}

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------
function FirstFrame()
{
	local tnmcamerapoint cp;
	local tnmpawn p;
	local navigationpoint n;
	local Dispatcher D;
	local trestkon t;
	local DXOgg music;
	local string track;

	Super.FirstFrame();

	t=trestkon(getplayerpawn());

	if (localURL == "25_TNMTRAINING")
	{
		// zero the player's skill points
		Player.SkillPointsTotal = 0;
		Player.SkillPointsAvail = 0;
		foreach allactors(class'tnmcamerapoint',cp,'tnmCameraPoint')
			cp.Trigger(none,none);
	}
	else
	{
		savedSoundVolume = SoundVolume;
	}


	if ( left( localURL, 10 ) ~= "TNMENDGAME")
	{
		t.bUnlockedSword=true;
		t.saveconfig();
	}

	if (localURL == "TNMINTRO")
	{
		// Trigger the intro cutscene immediately
		if (!flags.GetBool('MS_Intro_Played'))
		{
			foreach allactors(Class'tnmCameraPoint',cp,'Seq01')
			{
				cp.Trigger(none,none);
			}

			Flags.SetBool('MS_Intro_Played',true,,);
		}
	}
	if (localURL == "TNMENDGAME01")
	{
		// Trigger the cutscene immediately
		foreach allactors(Class'tnmCameraPoint',cp,'ScaraCam')
			cp.Trigger(none,none);

		// Spawn Trestkon on the space station
		foreach allactors(class'navigationpoint',n,'TrestkonSpawn1')
		{
			p=Spawn(class'Treskton',,'TrestkonSS',n.Location,n.Rotation);
			p.SetOrders('Standing',,);
			p.Bindname = "TrestkonSS";
			p.bUseLipsyncHack = true;
			p.ConBindEvents();
		}

		//Spawn Trestkon in the corporate sector
		foreach allactors(class'navigationpoint',n,'TrestkonSpawn2')
		{
			p=Spawn(class'Treskton',,'Trestkon',n.Location,n.Rotation);
			p.bUseLipsyncHack = true;
			p.SetOrders('Standing',,);
		}

		// Position DXO depending on whether or not TRM is dead
		if (flags.GetBool('TRM_Dead') || !flags.GetBool('TRM_Done'))
		{
			foreach allactors(class'tnmpawn',p,'DXOGuysMeeting')
				p.EnterWorld();
		}
		else
		{
			foreach allactors(class'tnmpawn',p,)
			{
				if ((p.Tag == 'DXOGuysLeaving') || (p.Tag == 'Compudoc'))
					p.EnterWorld();
			}
		}
	}
	if (localURL == "TNMENDGAME02")
	{
		// Trigger the cutscene immediately
		foreach allactors(Class'tnmCameraPoint',cp,'PDXHQCam01')
			cp.Trigger(none,none);

		// Position people depending on whether or not Scara was banned in M24
		if (flags.GetBool('Scara_Banned'))
		{
			// Remove Scara, first of all
			foreach allactors(class'tnmpawn',p,'ScaraKing')
				p.LeaveWorld();

			// Make Trestkon appear at the front
			foreach allactors(class'navigationpoint',n,'WC03')
			{
				p=Spawn(class'Treskton',,'treskton',n.Location,n.Rotation);
				p.bUseLipsyncHack = true;
				p.SetOrders('Standing',,);
			}

			// Make That Guy appear in the back
			foreach allactors(class'tnmpawn',p,'ThatGuy')
				p.EnterWorld();
		}
		else
		{
			// Make Trestkon appear in the back
			foreach allactors(class'navigationpoint',n,'TrestkonSpawn')
			{
				p=Spawn(class'Treskton',,'treskton',n.Location,n.Rotation);
				p.bUseLipsyncHack = true;
				p.SetOrders('Standing',,);
			}

			// Make That Guy appear next to ZeroPresence
			foreach allactors(class'tnmpawn',p,'ThatGuy_Prop')
				p.EnterWorld();
		}

		// Set a single flag to denote Kylie's presence to keep the convo relatively clean!
		if (flags.GetBool('Kylie_Dislike')||flags.GetBool('Kylie_Unconscious')||flags.GetBool('Kylie_Dead'))
			Flags.SetBool('Kylie_NotPresent',true,,);

		if(!flags.GetBool('Scara_Banned'))
		{
			if(!flags.GetBool('Kylie_NotPresent'))
			{
				track = "TNMEndgame02a.ogg";
			}
			else
			{
				track = "TNMEndgame02b.ogg";
			}
		}
		else
		{
			if(!flags.GetBool('Kylie_NotPresent'))
			{
				track = "TNMEndgame02c.ogg";
			}
			else
			{
				track = "TNMEndgame02d.ogg";
			}
		}

		music=Spawn(class'DXOgg');
		music.setcurrentOgg(track, "Blank.ogg", 0.0, MTRAN_Instant);
	}
	if (localURL == "TNMENDGAME03")
	{
		// Make Trestkon appear on the space station for the Narc ending
		foreach allactors(class'navigationpoint',n,'NarcTrestkonPoint01')
		{
			p=Spawn(class'Treskton',,'TrestkonNarc',n.Location,n.Rotation);
			p.SetOrders('Standing',,);
			p.bUnlit = True;
		}

		// Trigger the cutscene immediately
		if(flags.GetBool('ENDING_Narc'))
		{
			t.bUnlockedBulletTime=true;
			t.saveconfig();

			foreach allactors(Class'tnmCameraPoint',cp,'Narc01Cam')
				cp.Trigger(none,none);

			// For the Narcissus ending, also trigger the first convo
			foreach allactors(class'tnmpawn',p,'TrestkonNarc')
				break;
			StartConversationByName('NarcEndgame01', p, False, True);
		}
		else
			foreach allactors(Class'Dispatcher',D,'SSBlowup1')
				D.Trigger(none,none);

		// Make Trestkon appear for the ABI ending
		foreach allactors(class'navigationpoint',n,'TrestkonSpawn')
		{
			p=Spawn(class'Treskton',,'TresktonRyan',n.Location,n.Rotation);
			p.SetOrders('Standing',,);
		}

		// Make Trestkon appear in Downtown for the Narc ending
		foreach allactors(class'navigationpoint',n,'NarcTrestkonPointDT')
		{
			p=Spawn(class'Treskton',,'CircleTrestkon',n.Location,n.Rotation);
			p.SetOrders('Standing',,);

			// Set Trestkon's bindname to TresktonDT
			p.Bindname = "TresktonDT";
			p.ConBindEvents();
		}

		// Remove Kevo if the player is WC-aligned
		if (flags.GetBool('ALLIED_WC'))
		{
			foreach allactors(Class'tnmpawn',p,'Kevo')
				p.LeaveWorld();
		}
		// Remove Midashand if the player is PDX-aligned
		else
		{
			foreach allactors(Class'tnmpawn',p,'Midashand')
				p.LeaveWorld();
		}
	}
	if (localURL == "TNMDENOUEMENT")
	{
		// Trigger the cutscene immediately
		foreach allactors(Class'tnmCameraPoint',cp,'Cam00')
			cp.Trigger(none,none);

		// Remove the patrons of Sol's in the WC ending
		if (flags.GetBool('ALLIED_WC') && !flags.GetBool('QC_MAIN_DestroyLEETs'))
		{
			foreach allactors(class'tnmpawn',p,'SolsPatron')
				p.LeaveWorld();
		}

		// If Ryan has been banned, remove him from the map (makes sense, no?)
		if (flags.GetBool('Ryan_Banned'))
		{
			foreach allactors(class'tnmpawn',p,'Ryan')
				p.LeaveWorld();
		}

		// If Yardbomb is dead or was advised to sell...
		if (flags.GetBool('ALLIED_WC') && (flags.GetBool('Yardbomb_AdvisedToSell') || flags.GetBool('Yardbomb_Dead')))
		{
			// Remove Yardbomb if he's still alive
			if (!flags.GetBool('Yardbomb_Dead'))
			{
				foreach allactors(class'tnmpawn',p,'Yardbomb')
					p.LeaveWorld();
			}

			// Spawn the WC people
			foreach allactors(class'tnmpawn',p,'VoodooWCGuys')
				p.EnterWorld();
		}

		// Remove the goats (including OiNutter) if all cult leaders are dead
		if (flags.GetBool('Athena_Dead') && flags.GetBool('Beefman_Dead') && flags.GetBool('DarkTemplar_Dead') && flags.GetBool('Abomination_Dead'))
		{
			foreach allactors(class'tnmpawn',p,)
			{
				if ((p.Tag == 'Goats')||(p.Tag == 'OiNutter'))
					p.LeaveWorld();
			}
		}

		// Spawn Kylie in ZP's office
		if (flags.GetBool('ALLIED_WC') && flags.GetBool('Kylie_Dislike') && !flags.GetBool('Kylie_Dead'))
		{
			foreach allactors(class'tnmpawn',p,'Kylie_ZP')
				p.EnterWorld();
		}

		// Spawn Trestkon in the Partyzone
		foreach allactors(class'navigationpoint',n,'TrestkonSpawn_Partyzone')
		{
			p=Spawn(class'Treskton',,'TrestkonPZ',n.Location,n.Rotation);
			p.SetOrders('Standing',,);
		}

		// Spawn Trestkon in Scara's office
		foreach allactors(class'navigationpoint',n,'TrestkonSpawn_Scara')
		{
			p=Spawn(class'Treskton',,'TrestkonWC',n.Location,n.Rotation);
			p.SetOrders('Sitting','ScaraChair',);
		}

		// Spawn Trestkon by the sunset in the final scene
		foreach allactors(class'navigationpoint',n,'TrestkonSpawn_Final')
		{
			p=Spawn(class'Treskton',,'Trestkon',n.Location,n.Rotation);
			p.SetOrders('Standing',,);
		}
	}
}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{
	SoundVolume = savedSoundVolume;

	if ( player != none )
		Player.SetInstantSoundVolume(SoundVolume);

	Super.PreTravel();
}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{
	local int count;
	local tnmpawn p;
	local Lamp3 l;

	local WeaponMolBottle mol;

	local Augmentation aug;

	Super.Timer();

	if (localURL == "25_TNMTRAINING")
	{
		// WORST. SOLUTION. EVER! ...stupid ConEdit.
		Flags.SetBool('PM_Phas_DrinkWine_Played',false,,);

		// Play a PM when the security guard is knocked out
		count = 0;
		foreach allactors(class'tnmpawn',p,'CameraDummy')
			count++;
		if (count == 0)
		{
			SendPM("PM_Phas_Tut10");
		}

		// Play a PM when the fist dummy is knocked out
		count = 0;
		foreach allactors(class'tnmpawn',p,'FistDummy')
			count++;
		if (count == 0)
		{
			SendPM("PM_Phas_Tut12");
		}

		//First time the player gets a molotov cocktail, play the PM
		foreach allactors(class'WeaponMolBottle', mol, )
		{
			if ( mol.Owner == player)
				SendPM("PM_Phas_Tut15");
		}

		if(player!=None)
			aug=player.AugmentationSystem.FirstAug;

		while(aug!=None)
		{
			if(aug.IsA('AugLight') && aug.CurrentLevel==1)
				SendPM("PM_Phas_Tut19");

			if((aug.IsA('AugCombat') || aug.IsA('AugMuscle')) && aug.CurrentLevel==1)
				SendPM("PM_Phas_Tut20");

			aug=aug.next;
		}
	}
}

// ----------------------------------------------------------------------
// TRAINING FUNCTIONS
//
// Callback functions for the training mission
// ----------------------------------------------------------------------

function ActivateCamera()
{
	local SecurityCamera c;
	//Activate the security Camera
	foreach AllActors(class'SecurityCamera',c,'TrainingCamera')
	{
		c.bNoAlarm=False;
		c.bActive=true;
	}
}

function MaxComputers()
{
	local Skill aSkill;
	// max out the computers skill
	if (Player.SkillSystem != None)
	{
		aSkill = Player.SkillSystem.GetSkillFromClass(class'SkillComputer');
		if (aSkill != None)
			aSkill.CurrentLevel = 3;
	}
}

function UpgradeDemolitions()
{
	local Skill aSkill;
	// max out the demolitions skill
	if (Player.SkillSystem != None)
	{
		aSkill = Player.SkillSystem.GetSkillFromClass(class'tnmSkillDemolition');
		if (aSkill != None)
			aSkill.CurrentLevel = 1;
	}
}

function MaxDemolitions()
{
	local Skill aSkill;
	// max out the demolitions skill
	if (Player.SkillSystem != None)
	{
		aSkill = Player.SkillSystem.GetSkillFromClass(class'tnmSkillDemolition');
		if (aSkill != None)
			aSkill.CurrentLevel = 3;
	}
}

function MaxFists()
{
	local Skill aSkill;
	// max out the fists skill
	if (Player.SkillSystem != None)
	{
		aSkill = Player.SkillSystem.GetSkillFromClass(class'SkillWeaponFists');
		if (aSkill != None)
			aSkill.CurrentLevel = 3;
	}
}

function GiveTargettingAug()
{
	local Augmentation aug;

	player.AugmentationSystem.GivePlayerAugmentation(class'tnmpcAugTarget');

	aug=player.AugmentationSystem.FirstAug;
	while(aug!=None)
	{
		if(aug.IsA('AugTarget'))
		{
			aug.CurrentLevel=aug.MaxLevel;
			break;
		}
		aug=aug.next;
	}
}

function HidePhas()
{
	local tnmpawn Phas;
	foreach AllActors(class'tnmpawn', Phas, 'HoloPhas')
		Phas.LeaveWorld();
}

function UnHidePhas()
{
	local tnmpawn Phas;
	foreach AllActors(class'tnmpawn', Phas, 'HoloPhas')
		Phas.EnterWorld();
}

function RemoveAllInventory()
{
	local Inventory item, nextItem, lastItem;

	if (Player.Inventory != None)
	{
		item = Player.Inventory;
		nextItem = item.Inventory;
		lastItem = item;

		do
		{
			if (!item.IsA('weaponfists') && (item != None) && item.bDisplayableInv || item.IsA('Ammo'))
			{
				// make sure everything is turned off
				if (item.IsA('DeusExWeapon'))
				{
					DeusExWeapon(item).ScopeOff();
					DeusExWeapon(item).LaserOff();
				}
				if (item.IsA('DeusExPickup'))
				{
					if (DeusExPickup(item).bActive)
						DeusExPickup(item).Activate();
				}

   			if (item.IsA('ChargedPickup'))
					Player.RemoveChargedDisplay(ChargedPickup(item));

				Player.DeleteInventory(item);
				item.Destroy();
				item = Player.Inventory;
			}
			else
				item = nextItem;

			if (item != None)
				nextItem = item.Inventory;
		}
		until ((item == None) || (item == lastItem));
	}
}

function SendMoreWine()
{
	SpawnItemAt("TNMitems.WineBottleTrigger", 'SpawnMoreWine');
}

// ----------------------------------------------------------------------
// INTRO FUNCTIONS
//
// Callback functions for the intro cinematic
// ----------------------------------------------------------------------

function BanPawn(tnmpawn p)
{
	local BanInfo ban;
	ban=Spawn(Class'BanInfo');
	ban.StartBan(p);
}

function BanFighters()
{
	local tnmpawn screwed;
	foreach AllActors(Class'tnmpawn',screwed,'LlamaFighter')
		BanPawn(screwed);
	foreach AllActors(Class'tnmpawn',screwed,'GoatFighter')
		BanPawn(screwed);
}

function DDAppear()
{
	local tnmpawn p;

	// Make DD appear and move to his waypoint
	foreach allactors(class'tnmpawn',p,'DD')
	{
		p.EnterWorld();
		p.SetOrders('Patrolling','DDWaypoint01');
	}
}

function DDEquipSword()
{
	local tnmpawn dd;
	
	foreach allactors(class'tnmpawn',dd,'DD')
	{
		dd.bKeepWeaponDrawn=true;
		//dd.SetupWeapon(true,true);
		dd.SetWeapon(weapon(dd.Inventory));
	}
}

function DDEnterAlley()
{
	local tnmpawn dd;
	
	foreach allactors(class'tnmpawn',dd,'DD')
		dd.SetOrders('Patrolling','DDAlleyWaypoint',true);
}

function DDVanish()
{
	local tnmpawn dd;
	
	foreach allactors(class'tnmpawn',dd,'DD')
		dd.LeaveWorld();
}

function PlayIntro1()
{
	local tnmpawn dd;
	foreach allactors(class'tnmpawn',dd,'DD')
		break;
	StartConversationByName('Intro1', dd, False, True);
}

function PlayIntro2()
{
	local tnmpawn dd;
	foreach allactors(class'tnmpawn',dd,'DD')
		break;
	StartConversationByName('Intro2', dd, False, True);
}

function PlayIntro3()
{
	local tnmpawn dd;
	foreach allactors(class'tnmpawn',dd,'DD')
		break;
	StartConversationByName('Intro3', dd, False, True);
}

function PlayIntro4()
{
	local WHPhone WHP;
	local TAD TAD;
	foreach allactors(class'WHPhone',WHP,'PhasTAD')
		break;
	StartConversationByName('Intro4', WHP, False, True);
}

function PlayIntro5()
{
	local tnmpawn slicer;
	foreach allactors(class'tnmpawn',slicer,'Slicer')
		break;
	StartConversationByName('Intro5', slicer, False, True);
}

function PlayIntro6()
{
	local tnmpawn scara;
	foreach allactors(class'tnmpawn',scara,'ScaraKing')
		break;
	StartConversationByName('Intro6', scara, False, True);
}

function ArmThugs()
{
	local tnmpawn thug;
	foreach AllActors(class'tnmpawn',thug,'CheckpointThugs')
	{
		thug.bKeepWeaponDrawn=true;
		thug.SetupWeapon(true,true);
	}
}

function ClearCheckpoint()
{
	local tnmpawn p;
	local Vehicles V;

	foreach AllActors(class'tnmpawn',p,)
	{
		if ((p.Tag == 'CheckpointBusinessman') || (p.Tag == 'CheckpointThugs') || (p.Tag == 'CheckpointBystanders'))
			p.LeaveWorld();
	}

	foreach AllActors(class'Vehicles',V,)
	{
		if (V.Tag == 'CheckpointCars')
			V.LeaveWorld();
	}
}

function SpawnCultWar()
{
	local tnmpawn p;
	local tnmcarcass c;

	foreach allactors(class'tnmpawn',p,)
	{
		if ((p.Tag == 'Llamas') || (p.Tag == 'Goats'))
			p.EnterWorld();
	}

	foreach allactors(class'tnmcarcass',c,'CultCorpses')
		c.EnterWorld();
}

function KashueLeave()
{
	local tnmpawn p;

	// Spawn a copy of Kashue and move him to his waypoint
	foreach allactors(class'tnmpawn',p,'KashueLeaving')
	{
		p.EnterWorld();
		p.SetOrders('Patrolling','KKWaypoint',true);
	}
}

function TrestkonAppear()
{
	local navigationpoint n;
	local tnmpawn p;

	// Make Trestkon appear and move to his waypoint
	foreach allactors(class'navigationpoint',n,'TrestkonSpawn') // THIS IS NOT A TYPO!
	{
		p=Spawn(class'Treskton',,,n.Location,n.Rotation);
		p.SetOrders('Patrolling','TrestkonWaypoint',true);
	}
}

function EndIntro()
{
	Trestkon(GetPlayerPawn()).PostIntro();
}

// ----------------------------------------------------------------------
// ENDGAME FUNCTIONS
//
// Callback functions for the endgame cinematics
// ----------------------------------------------------------------------

function PrintEndgameQuote(int num)
{
	local int i;
	local DeusExRootWindow root;
	local HUDMissionStartTextDisplay quoteDisplay;

	root = DeusExRootWindow(Player.rootWindow);
	if (root != None)
	{
		quoteDisplay = HUDMissionStartTextDisplay(root.NewChild(Class'HUDMissionStartTextDisplay', True));
		if (quoteDisplay != None)
		{
			quoteDisplay.displayTime = endgameDelays[num];
			quoteDisplay.SetWindowAlignments(HALIGN_Center, VALIGN_Center);

			for (i=0; i<2; i++)
				quoteDisplay.AddMessage(endgameQuote[2*num+i]);

			quoteDisplay.StartMessage();
		}
	}
}

function RollCredits()
{
	local DeusExRootWindow root;
	local tnmCredits winCredits;

	root = DeusExRootWindow(player.rootWindow);

	if (root != None)
	{
		winCredits = tnmcredits(root.InvokeMenuScreen(Class'tnmcredits', false));
		winCredits.SetLoadIntro(true);
	}
}

// ----------------------------------------------------------------------
// PDX
// ----------------------------------------------------------------------

function BanScaraFX(tnmpawn p)
{
	local BanInfo ban;
	ban=Spawn(Class'BanInfo');
	ban.StartBan(p);
}

function PlayPDXEndgame01()
{
	local tnmpawn p;
	foreach allactors(class'tnmpawn',p,'ScaraHidden')
		break;
	player.StartConversationByName('PDXEndgame01', p, False, True);

	foreach AllActors(class'tnmpawn',p,'ScaraKing')
		break;
	p.GotoState('ScaraBan');
}

function BanScara()
{
	local tnmpawn p;
	// Apply the special Scara ban effect
	foreach AllActors(Class'tnmpawn',p,'ScaraKing')
		BanScaraFX(p);
}

function PlayPDXEndgame02()
{
	local tnmpawn p;
	foreach allactors(class'tnmpawn',p,'TrestkonSS')
		break;
	player.StartConversationByName('PDXEndgame02', p, False, True);
}

function TrestkonMoveUp()
{
	local tnmpawn t;	
	foreach allactors(class'tnmpawn',t,'Trestkon')
		t.SetOrders('Patrolling','TrestkonDestination',true);
}

function PlayPDXEndgame03()
{
	local tnmpawn p;
	foreach allactors(class'tnmpawn',p,'Phasmatis')
		break;
	player.StartConversationByName('PDXEndgame03', p, False, True);
}

function TRMAppear()
{
	local tnmpawn p;

	// Make TRM appear and move to his waypoint
	foreach allactors(class'tnmpawn',p,'TRM')
	{
		p.EnterWorld();
		p.SetOrders('Patrolling','TRMPosition',true);
	}
}

function DXOLightsOut()
{
	local lightbulb l;
	local triggerlight t;

	foreach allactors(class'lightbulb', l, 'DXOBulb')
	{
		l.LightType=LT_None;
		l.bUnlit=False;
	}

	foreach allactors(class'triggerlight', t, 'DXOLight')
		l.bCorona=False;
}

function BanWCThugs()
{
	local tnmpawn p;

	// Apply the ban effect from the intro to all the WC fighters in the slums
	// Note: I left the BanPawn function up there
	foreach AllActors(Class'tnmpawn',p,'SlumFighter3')
		BanPawn(p);
}

function DDSlumsAppear()
{
	local tnmpawn p;	
	foreach allactors(class'tnmpawn',p,'dd')
	{
		p.EnterWorld();
		p.SetOrders('Patrolling','DDPosition',true);
	}
}

// ----------------------------------------------------------------------
// WC
// ----------------------------------------------------------------------

function PlayWCEndgame01()
{
	local tnmpawn r;
	foreach allactors(class'tnmpawn',r,'Phasmatis')
		break;
	StartConversationByName('WCEndgame01', r, False, True);
}

function PlayWCEndgame02()
{
	local tnmpawn p;

	if (flags.GetBool('Scara_Banned'))
	{
		foreach allactors(class'tnmpawn',p,'ThatGuy')
			break;
		StartConversationByName('WCEndgame04', p, False, True);
	}
	else
	{
		foreach allactors(class'tnmpawn',p,'ScaraKing')
			break;
		StartConversationByName('WCEndgame02', p, False, True);
	}
}

function KylieAppear()
{
	local tnmpawn p;

	// Make Kylie appear and move to her waypoint
	foreach allactors(class'tnmpawn',p,'Kylie')
	{
		p.EnterWorld();

		// Kylie's waypoint is determined by whether Scara was banned or not
		if (flags.GetBool('Scara_Banned'))
		{
			p.SetOrders('Patrolling','WC02',true);
		}
		else
		{
			p.SetOrders('Patrolling','WC01',true);
		}
	}
}

function PlayWCEndgameKylie()
{
	local tnmpawn p;

	if (flags.GetBool('Scara_Banned'))
	{
		foreach allactors(class'tnmpawn',p,'Kylie')
			break;
		StartConversationByName('WCEndgame05', p, False, True);
	}
	else
	{
		foreach allactors(class'tnmpawn',p,'Kylie')
			break;
		StartConversationByName('WCEndgame03', p, False, True);
	}
}

function ScaraLeave()
{
	local tnmpawn p;
	
	foreach allactors(class'tnmpawn',p,)
	{
		if ((p.Tag == 'ScaraKing')||(p.Tag == 'ZeroPresence')||(p.Tag == 'ThatGuy_Prop'))
			p.SetOrders('Leaving','WCLeavePoint',true);
	}
}

function ThatGuyAndZPLeave()
{
	local tnmpawn p;
	
	foreach allactors(class'tnmpawn',p,)
	{
		if ((p.Tag == 'ThatGuy')||(p.Tag == 'ZeroPresence'))
			p.SetOrders('Leaving','WCLeavePoint',true);
	}
}

// ----------------------------------------------------------------------
// ABI
// ----------------------------------------------------------------------

function ShuttleSeq02Appear()
{
	local Vehicles V;
	foreach allactors(class'Vehicles',V,'ShuttleSeq02')
		V.EnterWorld();
}

function ShuttleReturnAppear()
{
	local Vehicles V;
	foreach allactors(class'Vehicles',V,'ShuttleReturn')
		V.EnterWorld();
}

function TrestkonLeaveShuttle()
{
	local tnmpawn t;	
	foreach allactors(class'tnmpawn',t,'TresktonRyan')
		t.SetOrders('Patrolling','TrestkonRyanPosition',true);
}

function PlayABIEndgame01()
{
	local tnmpawn r;
	foreach allactors(class'tnmpawn',r,'Ryan')
		break;
	StartConversationByName('ABIEndgame01', r, False, True);
}

function PlayABIEndgame02()
{
	local tnmpawn r;
	foreach allactors(class'tnmpawn',r,'Ryan')
		break;
	StartConversationByName('ABIEndgame02', r, False, True);	
}

function TrestkonLeaveABI()
{
	local tnmpawn t;	
	foreach allactors(class'tnmpawn',t,'TresktonRyan')
		t.SetOrders('Patrolling','TrestkonLeavePoint',true);
}

// ----------------------------------------------------------------------
// Narc
// ----------------------------------------------------------------------

function TrestWalkToPoint02()
{
	local tnmpawn t;	
	foreach allactors(class'tnmpawn',t,'TrestkonNarc')
		t.SetOrders('Patrolling','NarcTrestkonPoint02',true);
}

function PlayNarcEndgame02()
{
	local tnmpawn t;
	foreach allactors(class'tnmpawn',t,'TrestkonNarc')
		break;
	StartConversationByName('NarcEndgame02', t, False, True);
}

function TrestWalkToPoint03()
{
	local tnmpawn t;	
	foreach allactors(class'tnmpawn',t,'TrestkonNarc')
		t.SetOrders('Patrolling','NarcTrestkonPoint03',true);
}

function PlayNarcEndgame03()
{
	local tnmpawn t;
	foreach allactors(class'tnmpawn',t,'TrestkonNarc')
		break;
	StartConversationByName('NarcEndgame03', t, False, True);
}

function TrestWalkToPoint04()
{
	local tnmpawn t;	
	foreach allactors(class'tnmpawn',t,'TrestkonNarc')
		t.SetOrders('Patrolling','NarcTrestkonPoint04',true);
}

function PlayNarcEndgame04()
{
	local tnmpawn t;
	foreach allactors(class'tnmpawn',t,'TrestkonNarc')
		break;
	StartConversationByName('NarcEndgame04', t, False, True);
}

function FadeInAliens()
{
	local tnmpawn p;
	foreach allactors(class'tnmpawn',p)
		if(p.isa('alien'))
		{
			p.EnterWorld();
			fade(5,p,true);
		}
}

function SlowDown1()
{
	trestkon(player).slomoandpitch(0.5);
}

function SlowDown2()
{
	trestkon(player).slomoandpitch(0.25);
}

function NormalSpeed()
{
	trestkon(player).slomoandpitch(1.0);
}

function PlayNarcEndgame05()
{
	local tnmpawn t;
	foreach allactors(class'tnmpawn',t,'CircleTrestkon')
		break;
	StartConversationByName('NarcEndgame05', t, False, True);
}

function FadeOutTrestkon()
{
	local treskton t;
	foreach allactors(class'treskton',t,'CircleTrestkon')
		fade(2.0,t,false);
}

// ----------------------------------------------------------------------
// Denouement
// ----------------------------------------------------------------------

function PlayDenouement()
{
	local tnmpawn n;
	foreach allactors(class'tnmpawn',n,'Narcissus')
		break;
	player.StartConversationByName('01_Sols', n, False, True);
}

function SpawnGwog()
{
	local tnmpawn p;

	foreach allactors(class'tnmpawn',p,'Beeblequix')
	{
		p.multiskins[6]=Texture'pinkmasktex';
		
		// Then fade him out
		fade(2, p, FALSE);
	}

	foreach allactors(class'tnmpawn',p,'Gwog')
	{
		p.EnterWorld();
		fade(2, p, TRUE);
	}
}

function PlayDenouementEnd()
{
	local tnmpawn n;
	foreach allactors(class'tnmpawn',n,'Narcissus')
		break;
	player.StartConversationByName('17_Final', n, False, True);
}

// ----------------------------------------------------------------------
// CALLBACK SWITCH
// ----------------------------------------------------------------------

function HandleGameEvent(name scriptFunction)
{
//	Log("scriptfunction", scriptfunction);
	switch ( scriptfunction)
	{
		// Training
		case 'ActivateCamera' 		: ActivateCamera(); break;
		case 'MaxComputers' 		: MaxComputers(); break;
		case 'UpgradeDemolitions' 	: UpgradeDemolitions(); break;
		case 'MaxDemolitions' 		: MaxDemolitions(); break;
		case 'MaxFists' 		: MaxFists(); break;
		case 'GiveTargettingAug' 	: GiveTargettingAug(); break;
		case 'HidePhas' 		: HidePhas(); break;
		case 'UnHidePhas' 		: UnHidePhas(); break;
		case 'RemoveAllInventory' 	: RemoveAllInventory(); break;
		case 'SendMoreWine'		: SendMoreWine(); break;
		// Intro
		case 'BanFighters'		: BanFighters(); break;
		case 'DDAppear'			: DDAppear(); break;
		case 'DDEquipSword'		: DDEquipSword(); break;
		case 'DDEnterAlley'		: DDEnterAlley(); break;
		case 'DDVanish'			: DDVanish(); break;
		case 'PlayIntro1'		: PlayIntro1(); break;
		case 'PlayIntro2'		: PlayIntro2(); break;
		case 'PlayIntro3'		: PlayIntro3(); break;
		case 'PlayIntro4'		: PlayIntro4(); break;
		case 'PlayIntro5'		: PlayIntro5(); break;
		case 'PlayIntro6'		: PlayIntro6(); break;
		case 'ArmThugs'			: ArmThugs(); break;
		case 'ClearCheckpoint'		: ClearCheckpoint(); break;
		case 'SpawnCultWar'		: SpawnCultWar(); break;
		case 'KashueLeave'		: KashueLeave(); break;
		case 'TrestkonAppear'		: TrestkonAppear(); break;
		case 'EndIntro'			: EndIntro(); break;
		// Endgames
		case 'PrintEndgameQuoteABI'	: PrintEndgameQuote(0); break;
		case 'PrintEndgameQuoteWC1'	: PrintEndgameQuote(1); break;
		case 'PrintEndgameQuoteWC2'	: PrintEndgameQuote(2); break;
		case 'PrintEndgameQuotePDX'	: PrintEndgameQuote(3); break;
		case 'PrintEndgameQuoteNARC'	: PrintEndgameQuote(4); break;
		case 'RollCredits'		: RollCredits(); break;
		// PDX
		case 'PlayPDXEndgame01'		: PlayPDXEndgame01(); break;
		case 'BanScara'			: BanScara(); break;
		case 'PlayPDXEndgame02'		: PlayPDXEndgame02(); break;
		case 'TrestkonMoveUp'		: TrestkonMoveUp(); break;
		case 'PlayPDXEndgame03'		: PlayPDXEndgame03(); break;
		case 'TRMAppear'		: TRMAppear(); break;
		case 'DXOLightsOut'		: DXOLightsOut(); break;
		case 'BanWCThugs'		: BanWCThugs(); break;
		case 'DDSlumsAppear'		: DDSlumsAppear(); break;
		// WC
		case 'PlayWCEndgame01'		: PlayWCEndgame01(); break;
		case 'PlayWCEndgame02'		: PlayWCEndgame02(); break;
		case 'KylieAppear'		: KylieAppear(); break;
		case 'PlayWCEndgameKylie'	: PlayWCEndgameKylie(); break;
		case 'ScaraLeave'		: ScaraLeave(); break;
		case 'ThatGuyAndZPLeave'	: ThatGuyAndZPLeave(); break;
		// ABI
		case 'ShuttleSeq02Appear'	: ShuttleSeq02Appear(); break;
		case 'ShuttleReturnAppear'	: ShuttleReturnAppear(); break;
		case 'TrestkonLeaveShuttle'	: TrestkonLeaveShuttle(); break;
		case 'PlayABIEndgame01'		: PlayABIEndgame01(); break;
		case 'PlayABIEndgame02'		: PlayABIEndgame02(); break;
		case 'TrestkonLeaveABI'		: TrestkonLeaveABI(); break;
		// Narcissus
		case 'TrestWalkToPoint02'	: TrestWalkToPoint02(); break;
		case 'PlayNarcEndgame02'	: PlayNarcEndgame02(); break;
		case 'TrestWalkToPoint03'	: TrestWalkToPoint03(); break;
		case 'PlayNarcEndgame03'	: PlayNarcEndgame03(); break;
		case 'TrestWalkToPoint04'	: TrestWalkToPoint04(); break;
		case 'PlayNarcEndgame04'	: PlayNarcEndgame04(); break;
		case 'FadeInAliens'		: FadeInAliens(); break;
		case 'SlowDown1'		: SlowDown1(); break;
		case 'SlowDown2'		: SlowDown2(); break;
		case 'NormalSpeed'		: NormalSpeed(); break;
		case 'PlayNarcEndgame05'	: PlayNarcEndgame05(); break;
		case 'FadeOutTrestkon'		: FadeOutTrestkon(); break;
		case 'FadeInCircle'		: Spawn(class'NarcFadeInInfo'); break;
		// Denouement
		case 'PlayDenouement'		: PlayDenouement(); break;
		case 'SpawnGwog'		: SpawnGwog(); break;
		case 'PlayDenouementEnd'	: PlayDenouementEnd(); break;
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     endgameQuote(0)="EXISTENCE IS RANDOM. HAS NO PATTERN SAVE WHAT WE IMAGINE AFTER STARING AT IT FOR TOO LONG. NO MEANING SAVE WHAT WE CHOOSE TO IMPOSE."
     endgameQuote(1)="    -- ALAN MOORE"
     endgameQuote(2)="HERE'S TO LOWERING CASKETS OF OLD FRIENDS, CHOICE AND CONSEQUENCE - WE'LL BIRTH A NEW DAY WITH THE DEATH OF AN OLD AND START OVER."
     endgameQuote(3)="    -- ATREUY"
     endgameQuote(4)="CONSCIENCE IS BUT A WORD THAT COWARDS USE, DEVISED AT FIRST TO KEEP THE STRONG IN AWE."
     endgameQuote(5)="    -- WILLIAM SHAKESPEARE"
     endgameQuote(6)="IN A TRUE STATE OF NATURE, INDEED, ALL MEN ARE BORN EQUAL, BUT THEY CANNOT CONTINUE IN THIS EQUALITY... THEY RECOVER IT ONLY BY THE PROTECTION OF LAWS."
     endgameQuote(7)="    -- CHARLES DE MONTESQUIEU"
     endgameQuote(8)="NO REASON TO GET EXCITED, THE THIEF HE KINDLY SPOKE. THERE ARE MANY HERE AMONG US WHO FEEL THAT LIFE IS BUT A JOKE."
     endgameQuote(9)="    -- BOB DYLAN"
     endgameDelays(0)=13.000000
     endgameDelays(1)=12.500000
     endgameDelays(2)=10.000000
     endgameDelays(3)=15.500000
     endgameDelays(4)=11.000000
}
