class tnmProjectileBullet extends DeusExProjectile;

var ParticleGenerator TrailGen;

function PostBeginPlay()
{
	Super.PostBeginPlay();
	if(Trestkon(GetPlayerPawn()).bInBulletTime)
	{
		Mesh=LodMesh'DeusExItems.ShellCasing';
		SpawnTrailEffects();
		speed=4000;
	}
}

simulated function SpawnTrailEffects()
{
	TrailGen = Spawn(class'ParticleGenerator', Self);
	if (TrailGen != None)
	{
		TrailGen.RemoteRole = ROLE_None;
		TrailGen.particleTexture = Texture'DeusExitems.skins.FlatFXTex46';
		TrailGen.particleDrawScale = 0.02;
		TrailGen.checkTime = 0.009;
		TrailGen.riseRate = 0.0;
		TrailGen.ejectSpeed = 0.0;
		TrailGen.particleLifeSpan = 0.1;
		TrailGen.bRandomEject = True;
		TrailGen.SetBase(Self);
	}
}

simulated function SpawnEffects(Vector HitLocation, Vector HitNormal, Actor Other)
{
	local TraceHitSpawner hitspawner;
	super.SpawnEffects(HitLocation,HitNormal,Other);

	hitspawner = Spawn(class'TraceHitSpawner',Other,,HitLocation,Rotator(HitNormal));
	hitspawner.HitDamage = Damage;
	hitSpawner.damageType = damageType;
}

simulated function Destroyed()
{
	if (trailGen != None)
		TrailGen.DelayedDestroy();
	Super.Destroyed();
}

defaultproperties
{
     AccurateRange=16000
     maxRange=16000
     bIgnoresNanoDefense=True
     speed=8000.000000
     MaxSpeed=8000.000000
     Mesh=LodMesh'DeusExItems.SniperTracer'
//     Mesh=LodMesh'DeusExItems.ShellCasing2'
     Damage=15.000000
     MomentumTransfer=1000
//     ExplosionDecal=Class'DeusEx.BulletHole'
     ScaleGlow=2.000000
     bUnlit=True
     CollisionRadius=3.000000
     CollisionHeight=0.500000
}
