//this is the master class for all tnm scripted texture infos (I'm calling them controllers)
//	NVShacker 2/20/07
class tnmTextureController extends Info
	abstract;

var() ScriptedTexture SlaveTexture;
var bool bSwapNextRender;
var Texture swapBuffer;

//on beginplay we bind the slave texture to us and draw the first texture
simulated function BeginPlay() 
{ 
	if(slaveTexture != None)
	{
		slaveTexture.NotifyActor = Self;
		DrawInitialTexture();
	}
	else
		Destroy(); //without swapTexture our existence is meaningless! meaningless I say!
}

//subclasses can override this to draw the texture initially seen
simulated function DrawInitialTexture()
{
	return; //do nothing
}

//get rid of the slave's ref to us
simulated function Destroyed() 
{ 
	if(slaveTexture != None) 
		slaveTexture.NotifyActor = None;
}

//swaps the currently drawn texture for nexTex on next render
simulated function ChangeTex(Texture newTex)
{
	bSwapNextRender=true;
	swapBuffer=newTex;
}

//we do our texture replacing here
simulated event RenderTexture(ScriptedTexture T)
{
	local Texture S; //for the sake of readability
	if(bSwapNextRender)
	{
		S=swapBuffer; //Source
		T.Palette=S.Palette;
//		T.DrawTile(0, 0, T.USize, T.VSize, 0, 0, S.USize, S.VSize, S, false);
		T.ReplaceTexture(S);
	}
	return;
}

defaultproperties
{
     RemoteRole=ROLE_SimulatedProxy
     bAlwaysRelevant=True
}