//simple class that toggles the slave texture between primaryTexture and secondaryTexture
//can be triggered to do so
//	NVShacker 2/20/07
class tnmTextureSwapController extends tnmTextureController;

var() Texture primaryTexture;
var() Texture secondaryTexture;
var() bool bCanSwapBack;
var bool bSwapped;

simulated function DrawInitialTexture()
{
	ChangeTex(primaryTexture);
	return;
}

//toggles between primary and secondary
//stays secondary if !bCanSwapBack
simulated function Swap()
{
	if(!bSwapped)
		ChangeTex(secondaryTexture);
	else if(bCanSwapBack)
		ChangeTex(primaryTexture);
	else
		return;
	bSwapped = !bSwapped;
}

simulated event Trigger( Actor Other, Pawn EventInstigator )
{
	Swap();
	return;
}

defaultproperties
{
     bCanSwapBack=True
}