//allows the slave texture to be changed to up to 16 different textures
//	NVShacker 2/20/07
class tnmTextureSwitchController extends tnmTextureController;

enum TriggerBehavior
{
	ETEXSWAP_None,
	ETEXSWAP_Random,
	ETEXSWAP_Sequential
};

var() Texture TextureSet[16];
var() TriggerBehavior DefaultTriggerBehavior;
var int curIndex;

//initialize to first tex in set
simulated function DrawInitialTexture()
{
	SelectIndex(0);
	return;
}

//sets the texture to the one at i
simulated function SelectIndex(int i)
{
	ChangeTex(TextureSet[i]);
	curIndex=i;
	return;
}

//if triggered by tnmTextureSwitchTrigger we check its properites and behave
//accordingly, otherwise we consult our DefaultTriggerBehavior property
simulated event Trigger( Actor Other, Pawn EventInstigator )
{
	local tnmTextureSwitcher t;
	local int index;
	index=curIndex;
	t=tnmTextureSwitcher(Other);
	if(t!=None)
		index=t.TextureID;
	else
	{
		switch(DefaultTriggerBehavior)
		{
			case ETEXSWAP_None:
				break;
			case ETEXSWAP_Random:
				index=rand(16);
				while(TextureSet[index] == None)
					index=rand(16);				
				break;
			case ETEXSWAP_Sequential:
				index = ++index%16; //don't think the %= operator exists in uscript
				if(TextureSet[index]==None)
					index=0;
				break;				
		}
	}
	SelectIndex(index);
	return;
}

defaultproperties
{
}