//I'll try to throw anything that's handy and generic in here
class tnmUtil extends Object
	abstract;

var string packages[32];
struct ReplacePair
{
	var() string original;
	var() string replacement;
};
var ReplacePair replacements[256];

static function string CheckReplace(String ClassName)
{
	local int i;

	for(i=0;i<arraycount(Default.replacements);i++)
	{
		if(Default.replacements[i].original=="")
			break;

		if(classname~=Default.replacements[i].original)
			return Default.replacements[i].replacement;
	}
	
	return classname;
}

static function class<object> LookupClass(String ClassName)
{
	local int i;
	local class<object> ret;
	local string holdname;

	holdname = "" $ classname;
	if(instr(ClassName, ".") == -1)
	{
		ClassName=CheckReplace(ClassName);
		for(i=0;i<arraycount(Default.packages);i++)
		{
			if(Default.packages[i]=="")
				break;

			holdName = Default.packages[i] $ "." $ ClassName;
			ret = class<object>( DynamicLoadObject( holdName, class'Class' , true) );

			if(ret!=None)
				break;
		}
	}
	else
	{
		holdName = ""$ClassName;
		ret = class<object>(DynamicLoadObject(holdName, class'Class', true));
	}

	return ret;
}

static function AttemptReplaceModel(Actor a, class<actor> loadclass)
{
	local int i;
	if(loadclass!=None)
	{
		a.Mesh=loadclass.Default.Mesh;
		a.Skin=loadclass.Default.Skin;
		a.Texture=loadclass.Default.Texture;
		for(i=0;i<8;i++)
			a.Multiskins[i]=loadclass.Default.Multiskins[i];
	}
}

static function AttemptReplaceInventoryModel(Inventory i, class<inventory> loadclass)
{
	if(loadclass!=None)
	{
		I.PlayerViewOffset=loadclass.Default.PlayerViewOffset;
		I.PlayerViewMesh=loadclass.Default.PlayerViewMesh;
		I.PlayerViewScale=loadclass.Default.PlayerViewScale;

		I.PickupViewMesh=loadclass.Default.PickupViewMesh;
		I.PickupViewScale=loadclass.Default.PickupViewScale;

		I.ThirdPersonMesh=loadclass.Default.ThirdPersonMesh;
		I.ThirdPersonScale=loadclass.Default.ThirdPersonScale;

		I.Icon=loadclass.Default.Icon;

		I.largeIcon=loadclass.Default.largeIcon;
		I.largeIconWidth=loadclass.Default.largeIconWidth;
		I.largeIconHeight=loadclass.Default.largeIconHeight;
	}
}

defaultproperties
{
	packages(0)="Engine"
	packages(1)="DeusEx"
	packages(2)="TNM"
	packages(3)="TNMitems"
	packages(4)="TNMcharacters"
	packages(5)="TNMdeco"
	packages(6)="TNMGUI"
	packages(7)="TNMnative"
}