class tnmaugmentation extends actor;

var tnmpawn TNMP;

var() bool bAutomatic;
var bool bAlwaysActive;
var travel tnmAugmentation next;

// is it actually turned on?
var travel bool bIsActive;

var() sound ActivateSound;
var() sound DeactivateSound;

var bool bhealthactivated;
var bool bcombatactivated;

var float value;
var() string AugmentationName;



// ----------------------------------------------------------------------
// state Active 
//
// each augmentation should have its own version of this which actually
// implements the effects of having the augmentation on
// ----------------------------------------------------------------------

state Active
{
Begin:
	log("** AUGMENTATION: .Active should never be called!");
}

// ----------------------------------------------------------------------
// state Inactive
//
// don't do anything in this state
// ----------------------------------------------------------------------

auto state Inactive
{
}


// ----------------------------------------------------------------------
// Activate()
// ----------------------------------------------------------------------

function Activate()
{

	if (IsInState('Inactive'))
	{
		// this block needs to be before bIsActive is set to True, otherwise
		// NumAugsActive counts incorrectly and the sound won't work
		TNMP.PlaySound(ActivateSound, SLOT_None);

		bIsActive = True;

		GotoState('Active');
	}
}

// ----------------------------------------------------------------------
// Deactivate()
// ----------------------------------------------------------------------

function Deactivate()
{
	if (IsInState('Active'))
	{
		bIsActive = False;

		TNMP.PlaySound(DeactivateSound, SLOT_None);
		GotoState('Inactive');
	}
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     ActivateSound=Sound'DeusExSounds.Augmentation.AugActivate'
     DeActivateSound=Sound'DeusExSounds.Augmentation.AugDeactivate'
     bHidden=True
     DrawType=DT_None
}
