class tnmdatalinkplay extends datalinkplay;


struct S_newInfoLinkNames 
{
	var String BindName;
	var String DisplayName;
	var string portrait;
};

var S_newInfoLinkNames newinfolinknames[40];

function EEventAction SetupEventCheckFlag( ConEventCheckFlag event, out String nextLabel )
{
	return class'tnmconplay'.static.g_SetupEventCheckFlag(deusexplayer(GetPlayerPawn()),event,nextLabel);
}

// ----------------------------------------------------------------------
// GetDisplayName()
// ----------------------------------------------------------------------

function String GetDisplayName(String bindName)
{
	local int nameIndex;
	local string displayName;

	displayName = "";

	for(nameIndex=0; nameIndex<arrayCount(newinfoLinkNames); nameIndex++)
	{
		if (newinfoLinkNames[nameIndex].BindName == bindName)
		{
			displayName = newinfoLinkNames[nameIndex].DisplayName;
			break;
		}
	}
	return displayName;
}

function EEventAction SetupEventAddGoal( ConEventAddGoal event, out String nextLabel )
{

	local DeusExGoal goal;

	// First check to see if this goal exists
	goal = player.AddGoal(event.goalName, event.bPrimaryGoal);
//	goal.SetText(event.goalText);
	if ( event.bGoalCompleted )
		player.GoalCompleted(event.goalName);
	else
		goal.SetText(event.goalText);

	return EA_NextEvent;
}


function EEventAction SetupEventSpeech( ConEventSpeech event, out String nextLabel )
{
	local EEventAction nextAction;
	local ConEvent checkEvent;
	local String speech;
	local int nameIndex;
	local string portrait;


	// Keep track of the last speaker
	lastActor = event.speaker;

	// Display the first speech chunk.
	speech = event.conSpeech.speech;

	if (!bSilent)
	{
		// If we're continuing from the last speech, then we want to Append 
		// and not Display the first chunk.
		if ( event.bContinued == True )
		{
			datalink.AppendText(speech);
		}
		else
		{
			// Clear the window, set the name of the currently speaking
			// actor and then start displaying the speech.

			datalink.ClearScreen();
			datalink.SetSpeaker(event.speakerName, GetDisplayName(event.speakerName));

			portrait = "";

			for(nameIndex=0; nameIndex<arrayCount(newinfoLinkNames); nameIndex++)
			{
			if (newinfoLinkNames[nameIndex].BindName == event.speakername)
				{
				portrait = newinfoLinknames[nameIndex].portrait;
				break;
				}
			}
			tnmhudinfolinkdisplay(datalink).tnmsetportrait(Texture(DynamicLoadObject(portrait, class'Texture')));
			datalink.ShowPortrait();
			datalink.DisplayText(speech);

			lastSpeechTextLength = len(speech);
		}
	}

	// Save this event in the history
	AddHistoryEvent(GetDisplayName(event.speakerName), event.conSpeech );

	nextAction = EA_WaitForSpeech;
	nextLabel = "";
	return nextAction;
}

function class<inventory> getitemclass(string item)
{
return class<inventory>( DynamicLoadObject( item, class'Class' ) );
}

function EEventAction SetupEventCheckObject( ConEventCheckObject event, out String nextLabel )
{
	local EEventAction nextAction;
	local Name keyName;
	local bool bHasObject;

	// Okay this is some HackyHack stuff here.  We want the ability to 
	// check if the player has a particular nanokey.  Sooooooo.
	
	if ((event.checkObject == None) && (Left(event.objectName, 3) == "NK_"))
	{
		// Look for key
		keyName    = player.rootWindow.StringToName(Right(event.ObjectName, Len(event.ObjectName) - 3));
		bHasObject = ((player.KeyRing != None) && (player.KeyRing.HasKey(keyName)));
	}
	else 
	{
		bHasObject = (player.FindInventoryType(getitemclass(event.objectname)) != None);
	}

	// Now branch appropriately

	if (bHasObject)
	{
		nextAction = EA_NextEvent;
		nextLabel  = "";
	}
	else
	{
		nextAction = EA_JumpToLabel;
		nextLabel  = event.failLabel;
	}

	return nextAction;
}

function EEventAction SetupEventTransferObject( ConEventTransferObject event, out String nextLabel )
{
	local EEventAction nextAction;
	local Inventory invItemFrom;
	local Inventory invItemTo;
	local ammo AmmoType;
	local bool bSpawnedItem;
	local bool bSplitItem;
	local int itemsTransferred;

/*
log("SetupEventTransferObject()------------------------------------------");
log("  event = " $ event);
log("  event.giveObject = " $ event.giveObject);
log("  event.fromActor  = " $ event.fromActor );
log("  event.toActor    = " $ event.toActor );
*/
	itemsTransferred = 1;

	if ( event.failLabel != "" )
	{
		nextAction = EA_JumpToLabel;
		nextLabel  = event.failLabel;
	}
	else
	{
		nextAction = EA_NextEvent;
		nextLabel = "";
	}

	// First verify that the receiver exists!
	if (event.toActor == None)
	{
		return nextAction;
	}

	// First, check to see if the giver actually has the object.  If not, then we'll
	// fabricate it out of thin air.  (this is useful when we want to allow
	// repeat visits to the same NPC so the player can restock on items in some
	// scenarios).
	//
	// Also check to see if the item already exists in the recipient's inventory

	if (event.fromActor != None)
		invItemFrom = Pawn(event.fromActor).FindInventoryType(getitemclass(event.Objectname));

	invItemTo   = Pawn(event.toActor).FindInventoryType(getitemclass(event.Objectname));

//log("  invItemFrom = " $ invItemFrom);
//log("  invItemTo   = " $ invItemTo);

	// If the player is doing the giving, make sure we remove it from 
	// the object belt.

	// If the giver doesn't have the item then we must spawn a copy of it
	if (invItemFrom == None)
	{
		invItemFrom = Spawn(getitemclass(event.Objectname));
		bSpawnedItem = True;
	}

	// If we're giving this item to the player and he does NOT yet have it,
	// then make sure there's enough room in his inventory for the 
	// object!

	if ((invItemTo == None) &&
		(DeusExPlayer(event.toActor) != None) && 
	    (DeusExPlayer(event.toActor).FindInventorySlot(invItemFrom, True) == False))
	{
		// First destroy the object if we previously Spawned it
		if (bSpawnedItem)
			invItemFrom.Destroy();
				
		return nextAction;
	}

	// Okay, there's enough room in the player's inventory or we're not 
	// transferring to the player in which case it doesn't matter.
	//
	// Now check if the recipient already has the item.  If so, we are just
	// going to give it to him, with a few special cases.  Otherwise we
	// need to spawn a new object.

	if (invItemTo != None)
	{
		// Check if this item was in the player's hand, and if so, remove it
		RemoveItemFromPlayer(invItemFrom);

		// If this is ammo, then we want to just increment the ammo count
		// instead of adding another ammo to the inventory

		if (invItemTo.IsA('Ammo'))
		{
			// If this is Ammo and the player already has it, make sure the player isn't
			// already full of this ammo type! (UGH!)
			if (!Ammo(invItemTo).AddAmmo(Ammo(invItemFrom).AmmoAmount))
			{
				invItemFrom.Destroy();
				return nextAction;
			}

			// Destroy our From item
			invItemFrom.Destroy();		
		}

		// Pawn cannot have multiple weapons, but we do want to give the 
		// player any ammo from the weapon
		else if ((invItemTo.IsA('Weapon')) && (DeusExPlayer(event.ToActor) != None))
		{

			AmmoType = Ammo(DeusExPlayer(event.ToActor).FindInventoryType(Weapon(invItemTo).AmmoName));

			if ( AmmoType != None )
			{
				// Special case for Grenades and LAMs.  Blah.
				if ((AmmoType.IsA('AmmoEMPGrenade')) || 
				    (AmmoType.IsA('AmmoGasGrenade')) || 
					(AmmoType.IsA('AmmoNanoVirusGrenade')) ||
					(AmmoType.IsA('AmmoLAM')))
				{
					if (!AmmoType.AddAmmo(event.TransferCount))
					{
						invItemFrom.Destroy();
						return nextAction;
					}
				}
				else
				{
					if (!AmmoType.AddAmmo(Weapon(invItemTo).PickUpAmmoCount))
					{
						invItemFrom.Destroy();
						return nextAction;
					}

					event.TransferCount = Weapon(invItemTo).PickUpAmmoCount;
					itemsTransferred = event.TransferCount;
				}

				if (event.ToActor.IsA('DeusExPlayer'))
					DeusExPlayer(event.ToActor).UpdateAmmoBeltText(AmmoType);

				// Tell the player he just received some ammo!
				invItemTo = AmmoType;
			}
			else
			{
				// Don't want to show this as being received in a convo
				invItemTo = None;
			}

			// Destroy our From item
			invItemFrom.Destroy();
			invItemFrom = None;
		}

		// Otherwise check to see if we need to transfer more than 
		// one of the given item
		else
		{
			itemsTransferred = AddTransferCount(invItemFrom, invItemTo, event, Pawn(event.toActor), False);

			// If no items were transferred, then the player's inventory is full or 
			// no more of these items can be stacked, so abort.
			if (itemsTransferred == 0)
				return nextAction;

			// Now destroy the originating object (which we either spawned
			// or is sitting in the giver's inventory), but check to see if this 
			// item still has any copies left first

			if (((invItemFrom.IsA('DeusExPickup')) && (DeusExPickup(invItemFrom).bCanHaveMultipleCopies) && (DeusExPickup(invItemFrom).NumCopies <= 0)) ||
			   ((invItemFrom.IsA('DeusExPickup')) && (!DeusExPickup(invItemFrom).bCanHaveMultipleCopies)) ||
			   (!invItemFrom.IsA('DeusExPickup')))
			{
				invItemFrom.Destroy();
				invItemFrom = None;
			}
		}
	}

	// Okay, recipient does *NOT* have the item, so it must be give
	// to that pawn and the original destroyed
	else
	{
		// If the item being given is a stackable item and the 
		// recipient isn't receiving *ALL* the copies, then we 
		// need to spawn a *NEW* copy and give that to the recipient.
		// Otherwise just do a "SpawnCopy", which transfers ownership
		// of the object to the new owner.

		if ((invItemFrom.IsA('DeusExPickup')) && (DeusExPickup(invItemFrom).bCanHaveMultipleCopies) && 
		    (DeusExPickup(invItemFrom).NumCopies > event.transferCount))
		{
			itemsTransferred = event.TransferCount;
			invItemTo = Spawn(getitemclass(event.Objectname));
			invItemTo.GiveTo(Pawn(event.toActor));
			DeusExPickup(invItemFrom).NumCopies -= event.transferCount;
			bSplitItem   = True;
			bSpawnedItem = True;
		}
		else
		{
			invItemTo = invItemFrom.SpawnCopy(Pawn(event.toActor));
		}

//log("  invItemFrom = "$  invItemFrom);
//log("  invItemTo   = " $ invItemTo);

		if (DeusExPlayer(event.toActor) != None)
			DeusExPlayer(event.toActor).FindInventorySlot(invItemTo);

		// Check if this item was in the player's hand *AND* that the player is 
		// giving the item to someone else.
		if ((DeusExPlayer(event.fromActor) != None) && (!bSplitItem))
			RemoveItemFromPlayer(invItemFrom);

		// If this was a DataVaultImage, then the image needs to be 
		// properly added to the datavault
		if ((invItemTo.IsA('DataVaultImage')) && (event.toActor.IsA('DeusExPlayer')))
		{
			DeusExPlayer(event.toActor).AddImage(DataVaultImage(invItemTo));
				
			if (conWinThird != None)
				conWinThird.ShowReceivedItem(invItemTo, 1);
			else
				DeusExRootWindow(player.rootWindow).hud.receivedItems.AddItem(invItemTo, 1);

			invItemFrom = None;
			invItemTo   = None;
		}

		// Special case for Credit Chits also
		else if ((invItemTo.IsA('Credits')) && (event.toActor.IsA('DeusExPlayer')))
		{
			if (conWinThird != None)
				conWinThird.ShowReceivedItem(invItemTo, Credits(invItemTo).numCredits);
			else
				DeusExRootWindow(player.rootWindow).hud.receivedItems.AddItem(invItemTo, Credits(invItemTo).numCredits);

			player.Credits += Credits(invItemTo).numCredits;
			
			invItemTo.Destroy();

			invItemFrom = None;
			invItemTo   = None;
		}

		// Now check to see if the transfer event specified transferring
		// more than one copy of the object
		else
		{
			itemsTransferred = AddTransferCount(invItemFrom, invItemTo, event, Pawn(event.toActor), True);

			// If no items were transferred, then the player's inventory is full or 
			// no more of these items can be stacked, so abort.
			if (itemsTransferred == 0)
			{
				invItemTo.Destroy();
				return nextAction;
			}

			// Update the belt text
			if (invItemTo.IsA('Ammo'))
				player.UpdateAmmoBeltText(Ammo(invItemTo));
			else
				player.UpdateBeltText(invItemTo);
		}
	}

	// Show the player that he/she/it just received something!
	if ((DeusExPlayer(event.toActor) != None) && (conWinThird != None) && (invItemTo != None))
	{
		if (conWinThird != None)
			conWinThird.ShowReceivedItem(invItemTo, itemsTransferred);
		else
			DeusExRootWindow(player.rootWindow).hud.receivedItems.AddItem(invItemTo, itemsTransferred);
	}

	nextAction = EA_NextEvent;
	nextLabel = "";

	return nextAction;
}

defaultproperties
{
     newinfolinknames(0)=(BindName="Abomination",displayName="Abomination",portrait="TNM_Core_Tex.InfoPortraits.Info_Abom")
     newinfolinknames(1)=(BindName="Athena",displayName="Athena",portrait="TNM_Core_Tex.InfoPortraits.Info_Athena")
     newinfolinknames(2)=(BindName="Beeblequix",displayName="Beeblequix",portrait="TNM_Core_Tex.InfoPortraits.Info_Beeblequix")
     newinfolinknames(3)=(BindName="Beefman",displayName="Beefman",portrait="TNM_Core_Tex.InfoPortraits.Info_Beefman")
     newinfolinknames(4)=(BindName="BlackICE",displayName="Black ICE",portrait="TNM_Core_Tex.InfoPortraits.Info_BlackIce")
     newinfolinknames(5)=(BindName="DarkTemplar",displayName="Dark Templar",portrait="TNM_Core_Tex.InfoPortraits.Info_DT")
     newinfolinknames(6)=(BindName="Despot",displayName="Despot")
     newinfolinknames(7)=(BindName="DeusDiablo",displayName="Deus Diablo",portrait="TNM_Core_Tex.InfoPortraits.Info_DeusDiablo")
     newinfolinknames(8)=(BindName="Evil",displayName="Evil Invasion",portrait="TNM_Core_Tex.InfoPortraits.Info_Evil")
     newinfolinknames(9)=(BindName="Fender2k1",displayName="Fender2k1",portrait="TNM_Core_Tex.InfoPortraits.Info_Fender")
     newinfolinknames(10)=(BindName="FirewallAgent",displayName="Firewall Agent",portrait="TNM_Core_Tex.InfoPortraits.Info_Firewall")
     newinfolinknames(11)=(BindName="Hao",displayName="Hao Niu-rou",portrait="TNM_Core_Tex.InfoPortraits.Info_Hao")
     newinfolinknames(12)=(BindName="HelpSystem",displayName="Help System",portrait="TNM_Core_Tex.InfoPortraits.Info_Narcissus")
     newinfolinknames(13)=(BindName="Jackie",displayName="Jackie",portrait="TNM_Core_Tex.InfoPortraits.Info_Jackie")
     newinfolinknames(14)=(BindName="Jonas",displayName="Jonas",portrait="TNM_Core_Tex.InfoPortraits.Info_Jonas")
     newinfolinknames(15)=(BindName="Kevo",displayName="Kevo-sama",portrait="TNM_Core_Tex.InfoPortraits.Info_Critical")
     newinfolinknames(16)=(BindName="KingKashue",displayName="King Kashue",portrait="TNM_Core_Tex.InfoPortraits.Info_KingKashue")
     newinfolinknames(17)=(BindName="Kylie",displayName="Kylie",portrait="TNM_Core_Tex.InfoPortraits.Info_Kylie")
     newinfolinknames(18)=(BindName="Midashand",displayName="Midashand",portrait="TNM_Core_Tex.InfoPortraits.Info_Midashand")
     newinfolinknames(19)=(BindName="Narcissus",displayName="The Narcissus Entity",portrait="TNM_Core_Tex.InfoPortraits.Info_Narcissus")
     newinfolinknames(20)=(BindName="NVShacker",displayName="NVShacker",portrait="TNM_Core_Tex.InfoPortraits.Info_NVShacker")
     newinfolinknames(21)=(BindName="Phasmatis",displayName="Phasmatis",portrait="TNM_Core_Tex.InfoPortraits.Info_Phasmatis")
     newinfolinknames(22)=(BindName="PJ",displayName="Pimp Jojo",portrait="TNM_Core_Tex.InfoPortraits.Info_PimpJojo")
     newinfolinknames(23)=(BindName="Ricemanu",displayName="Ricemanu",portrait="TNM_Core_Tex.InfoPortraits.Info_Ricemanu")
     newinfolinknames(24)=(BindName="Ryan",displayName="Ryan",portrait="TNM_Core_Tex.InfoPortraits.Info_Ryan")
     newinfolinknames(25)=(BindName="Scara",displayName="Scara B. King",portrait="TNM_Core_Tex.InfoPortraits.Info_Scara")
     newinfolinknames(26)=(BindName="ShadowCode",displayName="ShadowCode",portrait="TNM_Core_Tex.InfoPortraits.Info_ShadowCode")
     newinfolinknames(27)=(BindName="Silver",displayName="Silver Dragon",portrait="TNM_Core_Tex.InfoPortraits.Info_Silver")
     newinfolinknames(28)=(BindName="Slicer",displayName="Slicer",portrait="TNM_Core_Tex.InfoPortraits.Info_Slicer")
     newinfolinknames(29)=(BindName="ThatGuy",displayName="That Guy",portrait="TNM_Core_Tex.InfoPortraits.Info_ThatGuy")
     newinfolinknames(30)=(BindName="TRM",displayName="TheRenegadeMaster",portrait="TNM_Core_Tex.InfoPortraits.Info_TRM")
     newinfolinknames(31)=(BindName="Winquman",displayName="Winquman",portrait="TNM_Core_Tex.InfoPortraits.Info_Winquman")
     newinfolinknames(32)=(BindName="Wolfy",displayName="Wolfy",portrait="TNM_Core_Tex.InfoPortraits.Info_Wolfy")
     newinfolinknames(33)=(BindName="Yardbomb",displayName="Yardbomb",portrait="TNM_Core_Tex.InfoPortraits.Info_Yardbomb")
     newinfolinknames(34)=(BindName="Zero",displayName="ZeroPresence",portrait="TNM_Core_Tex.InfoPortraits.Info_Zero")
}
