//=============================================================================
// AugDefense.
//=============================================================================
class tnmpcAugDefense extends AugDefense;

// Smoke39 - test only for being below maxlevel instead of CanBeUpgraded()
// which also looks for an aug upgrade can because
// 1. it's unnecessary here
// 2. it prevents upgrading with a redundant aug can
function bool IncLevel()
{
	if ( CurrentLevel >= MaxLevel )
	{
		Player.ClientMessage(Sprintf(AugAlreadyHave, AugmentationName));
		return False;
	}

	if (bIsActive)
		Deactivate();

	CurrentLevel++;
				
	Player.ClientMessage(Sprintf(AugNowHave, AugmentationName, CurrentLevel + 1));
}


simulated function DeusExProjectile FindNearestProjectile()
{
   local DeusExProjectile proj, minproj;
   local float dist, mindist;
   local bool bValidProj;

   minproj = None;
   mindist = 999999;
   foreach AllActors(class'DeusExProjectile', proj)
   {
      if (Level.NetMode != NM_Standalone)
         bValidProj = !proj.bIgnoresNanoDefense;
      else
         bValidProj = !proj.bIgnoresNanoDefense && !proj.IsA('Cloud') && !proj.IsA('Tracer') && !proj.IsA('GreaselSpit') && !proj.IsA('GraySpit'); //because of fail dx code

      if (bValidProj)
      {
         // make sure we don't own it
         if (proj.Owner != Player)
         {
			 // MBCODE : If team game, don't blow up teammates projectiles
			if (!((TeamDMGame(Player.DXGame) != None) && (TeamDMGame(Player.DXGame).ArePlayersAllied(DeusExPlayer(proj.Owner),Player))))
			{
				// make sure it's moving fast enough
				if (VSize(proj.Velocity) > 100)
				{
				   dist = VSize(Player.Location - proj.Location);
				   if (dist < mindist)
				   {
					  mindist = dist;
					  minproj = proj;
				   }
				}
			}
         }
      }
   }

   return minproj;
}

defaultproperties
{
}
