//-------------------------------------------
//weakmover scripted by me
//designed to smash when stood on
//-------------------------------------------

class weakmover extends breakablewall;

var() class<actor> breakingactors[9];
var() float smashmomentum; // mass multiplied by zvelocity. if zvelocity is more than -1 then it is set to -1

singular function SupportActor(Actor standingActor)
{
	local float  zVelocity;
	local float  baseMass;
	local float  standingMass;
	local int i;

	super.supportactor(standingactor);

	for(i=0; i<ArrayCount(breakingactors); i++)
	{

		if (standingactor.isa(breakingactors[i].name))
		{
			zVelocity = standingActor.Velocity.Z;
			if (zvelocity > -1)
				zvelocity = -1;
			if (zvelocity * standingActor.Mass * -1 >= smashmomentum)
			{

				if (bBreakable)
					BlowItUp(standingActor.Instigator);
			}
		}
	}

	if (!bDestroyed)
		standingActor.SetBase(self);
	else
		standingActor.SetPhysics(PHYS_Falling);
}

defaultproperties
{
     breakingactors(0)=Class'Engine.Actor'
     smashmomentum=1.000000
}
