//=============================================================================
// ABIEliteGuard
//=============================================================================
class ABIEliteGuard extends GenericAggressive;

//
// Damage type table for ABI Elite Guard (they are immune to gas thanks to their masks):
//
// TearGas		- 0%
// PoisonGas		- 0%
// HalonGas		- 0%
//

// Don't draw the shield effects
function DrawShield()
{
}

function float ShieldDamage(name damageType)
{
	// handle special damage types
	if ((damageType == 'TearGas') || (damageType == 'PoisonGas') || (damageType == 'HalonGas'))
		return 0.0;
	else
		return Super.ShieldDamage(damageType);
}

defaultproperties
{
     WalkingSpeed=0.296000
     CrouchRate=0.250000
     SprintRate=0.250000
     walkAnimMult=0.780000
     GroundSpeed=200.000000
     bCower=False
     CarcassType=Class'TNMCharacters.ABIEliteGuardCarcass'
     InitialInventory(0)=(Inventory=Class'TNMItems.WeaponTNMAssaultGun')
     InitialInventory(1)=(Inventory=Class'DeusEx.Ammo762mm',Count=12)
     InitialInventory(2)=(Inventory=Class'TNMItems.WeaponTNMCombatKnife')
     Texture=Texture'DeusExItems.Skins.PinkMaskTex'
     Mesh=LodMesh'DeusExCharacters.GM_Jumpsuit'
     MultiSkins(0)=Texture'TNMCharacters.Skins.ABISecurityTex0'
     MultiSkins(1)=Texture'TNMCharacters.Skins.MaleHitmanTex2'
     MultiSkins(2)=Texture'TNMCharacters.Skins.ABISecurityTex1'
     MultiSkins(3)=Texture'TNMCharacters.Skins.ABISecurityTex0'
     MultiSkins(4)=Texture'TNMCharacters.Skins.ABISecurityTex0'
     MultiSkins(5)=Texture'DeusExItems.Skins.GrayMaskTex'
     MultiSkins(6)=Texture'DeusExItems.Skins.PinkMaskTex'
     MultiSkins(7)=Texture'DeusExItems.Skins.PinkMaskTex'
     CollisionRadius=20.000000
     CollisionHeight=47.500000
     BarkBindName="ABIGuard"
     BindName="ABIGuard"
     FamiliarName="ABI Elite Guard"
     UnfamiliarName="ABI Elite Guard"
     Health=200
     HealthArmLeft=200
     HealthArmRight=200
     HealthHead=150
     HealthLegLeft=200
     HealthLegRight=200
     HealthTorso=250
}
