//=============================================================================
// Abomnation.
//=============================================================================
class Abomnation extends TNMAggressive;

//
// Damage type table for Abomination:
//
// Burned		- 50%
// Flamed		- 50%
//
// TearGas		- 0%
// PoisonGas		- 0%
// HalonGas		- 0%
//
// KnockedOut		- 0%
//

// Don't draw the shield effects
function DrawShield()
{
}

function float ShieldDamage(Name damageType)
{
	if (IgnoreDamageType(damageType))
		return 0.0;
	else if ((damageType == 'Burned') || (damageType == 'Flamed'))
		return 0.5;
	else if ((damageType == 'Poison') || (damageType == 'PoisonEffect') || (damageType == 'KnockedOut'))
		return 0.0;
	else
		return Super.ShieldDamage(damageType);
}

function Bool HasTwoHandedWeapon()
{
	return False;
}

function PlayReloadBegin()
{
	TweenAnimPivot('Shoot', 0.1);
}

function PlayReload()
{
}

function PlayReloadEnd()
{
}

function PlayIdle()
{
}

function TweenToShoot(float tweentime)
{
	if (Region.Zone.bWaterZone)
		TweenAnimPivot('TreadShoot', tweentime, GetSwimPivot());
	else if (!bCrouching)
		TweenAnimPivot('Shoot2', tweentime);
}

function PlayShoot()
{
	if (Region.Zone.bWaterZone)
		PlayAnimPivot('TreadShoot', , 0, GetSwimPivot());
	else
		PlayAnimPivot('Shoot2', , 0);
}

function bool IgnoreDamageType(Name damageType)
{
	if ((damageType == 'TearGas') || (damageType == 'PoisonGas'))
		return True;
	else
		return False;
}

function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if (!bCollideActors && !bBlockActors && !bBlockPlayers)
		return;
	else if (!IgnoreDamageType(damageType) && CanShowPain())
		TakeHit(hitPos);
	else
		GotoNextState();
}

defaultproperties
{
     baugmented=True
     BaseAccuracy=0.100000
     MinHealth=0.000000
     CarcassType=Class'tnmcharacters.AbomnationCarcass'
     WalkingSpeed=0.296000
     bCanCrouch=False
     CloseCombatMult=0.500000
     InitialInventory(1)=(Inventory=Class'WeaponTNMCommandoRocket')
     InitialInventory(2)=(Inventory=Class'DeusEx.AmmoRocketMini',Count=10)
     InitialInventory(3)=(Inventory=Class'WeaponTNMCommando')
     InitialInventory(4)=(Inventory=Class'DeusEx.Ammo762mm',Count=24)
     BurnPeriod=0.000000
     GroundSpeed=250.000000
     BaseEyeHeight=64.000000
     HealthHead=300
     HealthTorso=300
     HealthLegLeft=250
     HealthLegRight=250
     HealthArmLeft=250
     HealthArmRight=250
     HitSound1=Sound'DeusExSounds.Player.MalePainSmall'
     HitSound2=Sound'DeusExSounds.Player.MalePainMedium'
     Die=Sound'DeusExSounds.Player.MaleDeath' // NOTE! We need Abom to record his own death and pain sounds!
     Mesh=LodMesh'DeusExCharacters.GM_ScaryTroop'
     DrawScale=1.500000
     MultiSkins(0)=Texture'tnmcharacters.Skins.AbomnationTex0'
     MultiSkins(1)=Texture'tnmcharacters.Skins.AbomnationTex0'
     MultiSkins(2)=Texture'tnmcharacters.Skins.AbomnationTex1'
     MultiSkins(3)=Texture'tnmcharacters.Skins.AbomnationTex0'
     CollisionRadius=28.000000
     CollisionHeight=75.000000
     BarkBindName="Abomination"
     BindName="Abomination"
     FamiliarName="Abomination"
     UnfamiliarName="Llama Watchman"
     Health=250
     HealthArmLeft=350
     HealthArmRight=350
     HealthHead=350
     HealthLegLeft=350
     HealthLegRight=350
     HealthTorso=350
     augs(0)=class'TNM.tnmAugEMP'
     augs(1)=class'TNM.tnmAugDefense'
     augs(2)=class'TNM.tnmAugEnviro'
     augs(3)=class'TNM.tnmAugShield'
     augs(4)=class'TNM.tnmAugVision'
}
