//=============================================================================
// AlphaOperator.
//=============================================================================
class AlphaOperator extends TNMCivilian;

var() bool bHasNVSProgram;

function SpawnProgram()
{
	local NVShackerProgram program;

	program=Spawn(Class'NVShackerProgram',,,Location+vect(0,0,1)*(CollisionHeight+2.5));
	program.SetPhysics(PHYS_None);
	bHasNVSProgram=false;
}

function Carcass SpawnCarcass()
{
	if (Health < -100 && bHasNVSProgram)
		SpawnProgram();
	return super.SpawnCarcass();
}


defaultproperties
{
     bCower=False // He is a former special agent after all
     CarcassType=Class'tnmcharacters.AlphaOperatorCarcass'
     WalkingSpeed=0.213333
     bReactTheft=True
     walkAnimMult=0.750000
     GroundSpeed=180.000000
     Mesh=LodMesh'DeusExCharacters.GM_Trench_F'
     MultiSkins(0)=Texture'DeusExCharacters.Skins.GilbertRentonTex0'
     MultiSkins(1)=Texture'DeusExCharacters.Skins.PaulDentonTex2'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.MJ12TroopTex1'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.SamCarterTex0'
     MultiSkins(4)=Texture'DeusExCharacters.Skins.StantonDowdTex1'
     MultiSkins(5)=Texture'DeusExCharacters.Skins.PaulDentonTex2'
     MultiSkins(6)=Texture'DeusExCharacters.Skins.FramesTex4'
     MultiSkins(7)=Texture'DeusExCharacters.Skins.LensesTex2'
     CollisionRadius=20.000000
     CollisionHeight=47.500000
     BarkBindName="AlphaOperator"
     BindName="AlphaOperator"
     FamiliarName="Alpha Operator"
     UnfamiliarName="Alpha Operator"
     HealthHead=200
}
