//=============================================================================
// AlphaOperatorCarcass.
// auth: ryan
//=============================================================================
class AlphaOperatorCarcass extends tnmCarcass;

var bool bHasNVSProgram;

function SpawnProgram()
{
	local NVShackerProgram program;

	program=Spawn(Class'NVShackerProgram',,,Location+vect(0,0,1)*(CollisionHeight+2.5));
	program.SetPhysics(PHYS_None);
	bHasNVSProgram=false;
}

function InitFor(Actor Other)
{
	bHasNVSProgram=AlphaOperator(Other).bHasNVSProgram;
	super.InitFor(Other);
}

function Frob(Actor Frobber, Inventory frobWith)
{
	local NVShackerProgram program;

	super.Frob(Frobber,frobWith);

	if(bHasNVSProgram)
	{
		SpawnProgram();

		foreach AllActors(class'NVShackerProgram',program)
		{
			program.Frob(Frobber,frobWith);
			return;
		}
	}
}

function ChunkUp(int Damage)
{
	if(bHasNVSProgram)
		SpawnProgram();
	super.ChunkUp(Damage);
}

defaultproperties
{
     Mesh2=LodMesh'DeusExCharacters.GM_Trench_F_CarcassB'
     Mesh3=LodMesh'DeusExCharacters.GM_Trench_F_CarcassC'
     Mesh=LodMesh'DeusExCharacters.GM_Trench_F_Carcass'
     MultiSkins(0)=Texture'DeusExCharacters.Skins.GilbertRentonTex0'
     MultiSkins(1)=Texture'DeusExCharacters.Skins.PaulDentonTex2'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.MJ12TroopTex1'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.SamCarterTex0'
     MultiSkins(4)=Texture'DeusExCharacters.Skins.StantonDowdTex1'
     MultiSkins(5)=Texture'DeusExCharacters.Skins.PaulDentonTex2'
     MultiSkins(6)=Texture'DeusExCharacters.Skins.FramesTex4'
     MultiSkins(7)=Texture'DeusExCharacters.Skins.LensesTex2'
     CollisionRadius=40.000000
}
