//=============================================================================
// Athena.
//=============================================================================
class Athena extends TNMAggressive;

var AthenaRespawnEffect resfx;
var float respawn_time;

//mesh can't do 2-handed
function Bool HasTwoHandedWeapon()
{
	return False;
}

//never give up, never surrender, never flee, pet kittens etc etc -shax
function bool IsFearful()
{
	return false;
}

function Died(pawn Killer, name damageType, vector HitLocation)
{
	local tnmmission22 ms;
	local vector v;

	Log("Athena killed");

	foreach allactors(class'tnmMission22', ms, )
	{
		v = location;
		v.z -= CollisionHeight;
		ms.RespawnAthena(class, v);
	}	
	super.Died(killer, damagetype, hitlocation);
}

state Respawning
{
	ignores TakeDamage;

	function BeginState()
	{
		StandUp();
		LastPainTime = Level.TimeSeconds;
		LastPainAnim = AnimSequence;
		bInterruptState = false;
		BlockReactions();
		bCanConverse = False;
		bStasis = False;
		SetDistress(true);
		TakeHitTimer = 2.0;
		EnemyReadiness = 1.0;
		ReactionLevel  = 1.0;
		bInTransientState = true;
	}

	function Tick(float deltaTime)
	{
		Global.Tick(deltaTime);
		respawn_time+=deltaTime;
		ScaleGlow=fmin(respawn_time/2.5,1);
		if(resfx!=None)
			resfx.ScaleGlow=(1-ScaleGlow)*0.5;
	}

Begin:
	respawn_time=0;
	resfx=Spawn(Class'AthenaRespawnEffect',Self);
	Style = STY_Translucent;
	ScaleGlow = 0;
	MultiSkins[6]=Texture'BlackMaskTex';
	while ( ScaleGlow < 1.0 )
	{
		FinishAnim();
		PlayAnim('HitTorso', 4.0, 0.1);
		if(ScaleGlow>=1.0) //eww
			break;

		PlayAnim('HitHead', 4.0, 0.1);
		FinishAnim();
		if(ScaleGlow>=1.0)
			break;

		PlayAnim('HitTorsoBack', 4.0, 0.1);
		FinishAnim();
		if(ScaleGlow>=1.0)
			break;

		PlayAnim('HitHeadBack', 4.0, 0.1);
		FinishAnim();
		if(ScaleGlow>=1.0)
			break;

		PlayAnim('HitHead', 6.0, 0.1);
		FinishAnim();
		if(ScaleGlow>=1.0)
			break;

		PlayAnim('HitHeadBack', 6.0, 0.1);
		FinishAnim();
		if(ScaleGlow>=1.0)
			break;

		PlayAnim('HitHead', 10.0, 0.1);
		FinishAnim();
		if(ScaleGlow>=1.0)
			break;

		PlayAnim('HitHeadBack', 10.0, 0.1);
		FinishAnim();
	}
	resfx.Destroy();
	MultiSkins[6]=Texture'GrayMaskTex';
	Style = STY_Normal;
	Enemy = GetPlayerPawn();
	GotoState('Attacking');
}

function DropItems()
{
	local bool bValidItem;
	local inventory item, nextItem;
	local Vector loc;

	if(inventory != none)
	{
		do
		{
			item = Inventory;
			nextItem = item.Inventory;
			bValidItem = true;
	                DeleteInventory(item);
			Item.Destroy();
			item = nextItem;
		}
		until (item == None)
	}
	super.DropItems();
}

defaultproperties
{
     baugmented=True
     Tag=Athena
     CarcassType=Class'tnmcharacters.AthenaCarcass'
     WalkingSpeed=0.320000
     BaseAssHeight=-18.000000
     walkAnimMult=0.650000
     bIsFemale=True
     GroundSpeed=120.000000
     BaseEyeHeight=38.000000
     Mesh=LodMesh'DeusExCharacters.GFM_Trench'
     MultiSkins(0)=Texture'DeusExCharacters.Skins.ScientistFemaleTex0'
     MultiSkins(1)=Texture'DeusExCharacters.Skins.LabCoatTex1'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.PantsTex10'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.ScientistFemaleTex0'
     MultiSkins(4)=Texture'DeusExCharacters.Skins.SmugglerTex1'
     MultiSkins(5)=Texture'DeusExCharacters.Skins.LabCoatTex1'
     MultiSkins(6)=Texture'DeusExItems.Skins.GrayMaskTex'
     MultiSkins(7)=Texture'DeusExItems.Skins.BlackMaskTex'
     CollisionRadius=20.000000
     CollisionHeight=43.000000
     BarkBindName="Athena"
     BindName="Athena"
     FamiliarName="Athena"
     UnfamiliarName="Goat High Priestess"
     Health=400
     HealthArmLeft=400
     HealthArmRight=400
     HealthHead=600
     HealthLegLeft=400
     HealthLegRight=400
     HealthTorso=400
     aughealthlimit=250.000000
     augs(0)=class'TNM.tnmAugDefense'
     augs(1)=class'TNM.tnmAugSpeed'
     augs(2)=class'TNM.tnmAugVision'
     bSmartWeapons=True
     InitialInventory(0)=(Inventory=Class'TNMItems.WeaponTNMAssaultShotgun')
     InitialInventory(1)=(Inventory=Class'DeusEx.AmmoShell',Count=10)
     InitialInventory(2)=(Inventory=Class'TNMItems.WeaponTNMFlamethrower')
     InitialInventory(3)=(Inventory=Class'TNMItems.AmmoTNMNapalm',Count=8)
     InitialInventory(4)=(Inventory=Class'TNMItems.WeaponTNMEMPGrenade',Count=3)
     InitialInventory(5)=(Inventory=Class'TNMItems.WeaponTNMNanoSword')
}
