//=============================================================================
// Illuminati
//=============================================================================
class Illuminati extends TNMAggressive;

//
// Damage type table for Illuminati (he is immune to gas thanks to his mask):
//
// TearGas		- 0%
// PoisonGas		- 0%
// HalonGas		- 0%
//

// Don't draw the shield effects
function DrawShield()
{
}

function float ShieldDamage(name damageType)
{
	// handle special damage types
	if ((damageType == 'TearGas') || (damageType == 'PoisonGas') || (damageType == 'HalonGas'))
		return 0.0;
	else
		return Super.ShieldDamage(damageType);
}

defaultproperties
{
     MaxProvocations=0 // DXO is a bit on edge, having a PDX agent walking around in the hideout
     bAugmented=True
     CarcassType=Class'tnmcharacters.IlluminatiCarcass'
     Mesh=LodMesh'DeusExCharacters.GM_Suit'
     WalkingSpeed=0.213333
     walkAnimMult=0.750000
     GroundSpeed=180.000000
     MultiSkins(0)=Texture'DeusExCharacters.Skins.IlluminatiTex0'
     MultiSkins(1)=Texture'DeusExCharacters.Skins.IlluminatiTex2'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.IlluminatiTex0'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.IlluminatiTex1'
     MultiSkins(4)=Texture'DeusExCharacters.Skins.IlluminatiTex1'
     MultiSkins(5)=Texture'DeusExItems.Skins.GrayMaskTex'
     MultiSkins(6)=Texture'DeusExItems.Skins.BlackMaskTex'
     MultiSkins(7)=Texture'DeusExItems.Skins.PinkMaskTex'
     CollisionRadius=20.000000
     CollisionHeight=47.500000
     Health=200
     HealthArmLeft=200
     HealthArmRight=200
     HealthHead=300
     HealthLegLeft=200
     HealthLegRight=200
     HealthTorso=200
     BarkBindName="Illuminati"
     BindName="Illuminati"
     FamiliarName="Illuminati IIS"
     UnfamiliarName="Illuminati IIS"
     augs(0)=class'TNM.tnmAugDefense'
     augs(1)=class'TNM.tnmAugShield'
     augs(2)=class'TNM.tnmAugHealing'
}