//=============================================================================
// Kylie.
//=============================================================================
class Kylie extends TNMAggressive;

var() texture faceplate;
var bool bUseFaceplate;

// Always use one-hand weapon animations (as she has no 2-hand anims, bleh)
function Bool HasTwoHandedWeapon()
{
	return False;
}

// Immune to knockout and poison
function float ShieldDamage(name damageType)
{
	if ((damageType == 'Stunned') || (damageType == 'KnockedOut') || (damageType == 'headstun') ||
	    (damageType == 'Poison') || (damageType == 'PoisonEffect'))
		return 0.0;
	else
		return Super.ShieldDamage(damageType);
}

function Carcass SpawnCarcass()
{
	local carcass carc;
	carc = super.spawncarcass();
	carc.multiskins[0] = multiskins[0];
	return carc;
}

function SwitchToKilledSkin()
{
	MultiSkins[0]=faceplate;
	bUseFaceplate = true;
}

//copied from scriptedpawn with faceplate change
function ResetSkinStyle()
{
	local int i;

	for (i=0; i<8; i++)
		MultiSkins[i] = Default.MultiSkins[i];
	if ( bUseFaceplate )
		MultiSkins[0]=faceplate;
	Skin      = Default.Skin;
	ScaleGlow = Default.ScaleGlow;
	Style     = Default.Style;
}

defaultproperties
{
     baugmented=True
     BaseAccuracy=0.050000
     CarcassType=Class'tnmcharacters.KylieCarcass'
     WalkingSpeed=0.320000
     BaseAssHeight=-18.000000
     walkAnimMult=0.650000
     bIsFemale=True
     GroundSpeed=120.000000
     BaseEyeHeight=38.000000
     Mesh=LodMesh'DeusExCharacters.GFM_Trench'
     faceplate=Texture'tnmcharacters.Skins.KylieTex0b'
     MultiSkins(0)=Texture'tnmcharacters.Skins.KylieTex0'
     MultiSkins(1)=Texture'tnmcharacters.Skins.KylieTex2'
     MultiSkins(2)=Texture'tnmcharacters.Skins.KylieTex3'
     MultiSkins(3)=Texture'tnmcharacters.Skins.KylieTex0'
     MultiSkins(4)=Texture'tnmcharacters.Skins.KylieTex1'
     MultiSkins(5)=Texture'tnmcharacters.Skins.KylieTex2'
     MultiSkins(6)=Texture'DeusExItems.Skins.GrayMaskTex'
     MultiSkins(7)=Texture'DeusExItems.Skins.BlackMaskTex'
     CollisionRadius=20.000000
     CollisionHeight=43.000000
     BarkBindName="Kylie"
     BindName="Kylie"
     FamiliarName="Kylie Griffin"
     UnfamiliarName="Kylie Griffin"
     Health=600
     HealthArmLeft=600
     HealthArmRight=600
     HealthHead=900
     HealthLegLeft=600
     HealthLegRight=600
     HealthTorso=600
     aughealthlimit=400.000000
     augs(0)=class'TNM.tnmAugDefense'
     augs(1)=class'TNM.tnmAugBallistic'
     augs(2)=class'TNM.tnmAugCloakhealth'
     augs(3)=class'TNM.tnmAugEMP'
     augs(4)=class'TNM.tnmAugHealing'
     augs(5)=class'TNM.tnmAugSpeed'
     augs(6)=class'TNM.tnmAugTarget'
}
