//it's a spiderbot!
//note: may not be house trained
//only uses litter box to store charred corpses
class NVShackerPet extends TNMRobot;

var bool bHunting;
var float wait;

//it's specifically designed not to use bot IFF because of scrambler nades
//so it being affected by them would be... silly
function bool IgnoreDamageType(Name damageType)
{
	if(damageType=='NanoVirus')
		return true;
	return super.IgnoreDamageType(damageType);
}

//set NVShackerPet_Unconscious if EMP'd
state Disabled
{
	function BeginState()
	{
		local name flagName;
		local Trestkon player;

		super.BeginState();

		if (EMPHitPoints <= 0)
		{
			player=Trestkon(GetPlayerPawn());
			flagName = player.rootWindow.StringToName(BindName$"_Unconscious");
			player.flagBase.SetBool(flagName, True);
			player.flagBase.SetExpiration(flagName, FLAG_Bool, 0);
		}
	}
}

function Tick(float deltaTime)
{
	if(!bHunting)
		return;
	wait+=deltaTime;
	if(wait>=1.0)
	{
		SetAgitation();
		wait=0;
	}
	super.Tick(deltaTime);
}

function SetAgitation()
{
	local ScriptedPawn p, e;
	local float min;
	foreach AllActors(Class'ScriptedPawn', p)
		if(p.GetAllianceType(Alliance) == Alliance_HOSTILE)
		{
			ChangeAlly(p.Alliance,- 1.0, true);
			if(p.isa('tnmanimal'))
				continue;
			if(e==none)
			{
				min=vsize(location-p.location);
				e=p;
			}
			else if(vsize(location-p.location)<min)
			{
				min=vsize(location-p.location);
				e=p;
			}
		}
	SetOrders('Following',,true);
	if(enemy==none)
		setenemy(e);
	super.PostBeginPlay();
}


defaultproperties
{
     MaxStepHeight=8.00000
     dominatable=False
     EMPHitPoints=35
     maxRange=1536.000000
     MinRange=100.000000
     WalkingSpeed=1.000000
     bKeepWeaponDrawn=True
     InitialInventory(0)=(Inventory=Class'WeaponNVShackerPet')
     InitialInventory(1)=(Inventory=Class'DeusEx.AmmoBattery',Count=99)
     WalkSound=Sound'DeusExSounds.Robot.SpiderBot2Walk'
     GroundSpeed=200.000000
     WaterSpeed=50.000000
     AirSpeed=144.000000
     PeripheralVision=-1.000000
     HearingThreshold=0.000000
     Health=100
     UnderWaterTime=20.000000
     AttitudeToPlayer=ATTITUDE_Ignore
     Skill=20.000000
     AIHorizontalFov=360.000000
     DrawType=DT_Mesh
     Mesh=LodMesh'DeusExCharacters.SpiderBot2'
     Skin=Texture'TNMCharacters.Skins.NVShackerPetTex1'
     DrawScale=0.500000
     CollisionRadius=17.000000
     CollisionHeight=7.500000
     Mass=50.000000
     Buoyancy=50.000000
     BarkBindName="NVShackerPet"
     BindName="NVShackerPet"
     FamiliarName="A2"
     UnfamiliarName="Spiderbot"
     bImportant=True //:O
}
