class Phaser extends GenericAggressive;

var float phaseintime;
var float phaseouttime;
var float phaseinmaxtime;
var float phaseoutmaxtime;
var vector phasedestination;
var TNMPhaseEffect fx;


function PlayDying(name damageType, vector hitLoc)
{
	local Vector X, Y, Z;
	local float dotp;

//	ClientMessage("PlayDying()");
	if (Region.Zone.bWaterZone)
		PlayAnimPivot('WaterDeath',, 0.1);
	else if (bSitting)  // if sitting, always fall forward
		PlayAnimPivot('DeathFront',, 0.1);
	else
	{
		GetAxes(Rotation, X, Y, Z);
		dotp = (Location - HitLoc) dot X;

		// die from the correct side
		if (dotp < 0.0)		// shot from the front, fall back
			PlayAnimPivot('DeathBack',, 0.1);
		else				// shot from the back, fall front
			PlayAnimPivot('DeathFront',, 0.1);
	}

	// don't scream if we are stunned
	if ((damageType == 'Stunned') || (damageType == 'KnockedOut') ||
	    (damageType == 'Poison') || (damageType == 'PoisonEffect'))
	{
		bStunned = True;
	}
	else
	{
		bStunned = False;
	}
	//Always play the dying sound even if knocked out
	PlayDyingSound();
}

function TweenToAttack(float tweentime)
{
	TweenAnimPivot('Shoot', tweentime);
}

function PlayAttack()
{
	PlayAnimPivot('Shoot');
}

function GotoNextState()
{
	if(IsInState('Attacking'))
	{
		Style=STY_Normal;
		ScaleGlow=1;
		if(fx!=None)
			fx.Destroy();
	}
	super.GotoNextState();
}

State Attacking
{
	function tick(float deltatime)
	{
		super.tick(deltatime);
		if (phaseouttime > 0)
		{
			phaseouttime -= deltatime;
			if (phaseouttime < 0)
			{
				phaseouttime = 0;
				phaseintime = phaseinmaxtime;
				if (!SetLocation( phasedestination ))
					Log("Phaser failed to phase. Don't worry about this unless there's a crash.");
			}
			Style=STY_Translucent;
			ScaleGlow = phaseouttime / phaseoutmaxtime;
		}
		else if ( phaseintime > 0)
		{
			phaseintime -= deltatime;
			if ( phaseintime < 0)
			{
				phaseintime = 0;
				Style=STY_Normal;
				if(fx!=None)
				{
					fx.Destroy();
					fx=None;
				}
			}
			ScaleGlow = (phaseinmaxtime - phaseintime) / phaseinmaxtime;
		}

		if(fx!=None)
			fx.ScaleGlow=ScaleGlow*0.5;
	}

	function PortTo(vector loc)
	{
		phaseintime = 0;
		phaseouttime = phaseoutmaxtime;
		phasedestination = loc;
		if(fx==None)
			fx=Spawn(Class'TNMPhaseEffect',Self);
	}

	function PortToActor(actor act)
	{
		PortTo(act.Location);
	}

Begin:
	if (Enemy == None)
		GotoState('Seeking');
	//EnemyLastSeen = 0;
	CheckAttack(false);

Surprise:
	if ((1.0-ReactionLevel)*SurprisePeriod < 0.25)
		Goto('BeginAttack');
	Acceleration=vect(0,0,0);
	PlaySurpriseSound();
	PlayWaiting();
	while (ReactionLevel < 1.0)
	{
		TurnToward(Enemy);
		Sleep(0);
	}

BeginAttack:
	EnemyReadiness = 1.0;
	ReactionLevel  = 1.0;
	if (PlayerAgitationTimer > 0)
		PlayAllianceHostileSound();
	else
		PlayTargetAcquiredSound();
	if (PlayBeginAttack())
	{
		Acceleration = vect(0,0,0);
		TurnToward(enemy);
		FinishAnim();
	}

RunToRange:
	bCanFire       = false;
	bFacingTarget  = false;
	bReadyToReload = false;
	EndCrouch();
	if (Physics == PHYS_Falling)
		TweenToRunning(0.05);
	WaitForLanding();
	if (!IsWeaponReloading() || bCrouching)
	{
		if (ShouldPlayTurn(Enemy.Location))
			PlayTurning();
		TurnToward(enemy);
	}
	else
		Sleep(0);
	bCanFire = true;
	while (PickDestination() == DEST_NewLocation)
	{
		bFacingTarget = false;
//		PlayRunning();
		if (destPoint != None)
			PortToActor(destPoint);
		else
			PortTo(destLoc);
		Sleep(phaseinmaxtime + phaseoutmaxtime);
		CheckAttack(true);
	}

Fire:
	bCanFire      = false;
	bFacingTarget = false;
	Acceleration = vect(0, 0, 0);

	SwitchToBestWeapon();
	if (FRand() > 0.5)
		bUseSecondaryAttack = true;
	else
		bUseSecondaryAttack = false;
	if (IsHandToHand())
		TweenToAttack(0.15);
	else if (ShouldCrouch() && (FRand() < CrouchRate))
	{
		TweenToCrouchShoot(0.15);
		FinishAnim();
		StartCrouch();
	}
	else
		TweenToShoot(0.15);
	if (!IsWeaponReloading() || bCrouching)
		TurnToward(enemy);
	FinishAnim();
	bReadyToReload = true;

ContinueFire:
	while (!ReadyForWeapon())
	{
		if (PickDestination() != DEST_SameLocation)
			Goto('RunToRange');
		CheckAttack(true);
		if (!IsWeaponReloading() || bCrouching)
			TurnToward(enemy);
		else
			Sleep(0);
	}
	CheckAttack(true);
	if (!FireIfClearShot())
		Goto('ContinueAttack');
	bReadyToReload = false;
	if (bCrouching)
		PlayCrouchShoot();
	else if (IsHandToHand())
		PlayAttack();
	else
		PlayShoot();
	FinishAnim();
	if (FRand() > 0.5)
		bUseSecondaryAttack = true;
	else
		bUseSecondaryAttack = false;
	bReadyToReload = true;
	if (!IsHandToHand())
	{
		if (bCrouching)
			TweenToCrouchShoot(0);
		else
			TweenToShoot(0);
	}
	CheckAttack(true);
	if (PickDestination() != DEST_NewLocation)
	{
		if (!IsWeaponReloading() || bCrouching)
			TurnToward(enemy);
		else
			Sleep(0);
		Goto('ContinueFire');
	}
	Goto('RunToRange');

ContinueAttack:
ContinueFromDoor:
	CheckAttack(true);
	if (PickDestination() != DEST_NewLocation)
		Goto('Fire');
	else
		Goto('RunToRange');
}

function PlayFalling()
{
}

defaultproperties
{
     bCanTurnHead=false
     phaseinmaxtime=0.3
     phaseoutmaxtime=0.3
     InitialInventory(0)=(Inventory=Class'TNMCharacters.weaponphaserbolt')
     InitialInventory(1)=(Inventory=Class'DeusEx.AmmoBattery',Count=99)
     MinHealth=10.000000
     CarcassType=Class'PhaserCarcass'
     WalkingSpeed=0.280000
     bCanBleed=True
     CloseCombatMult=0.000000
     ShadowScale=0.750000
     WalkSound=Sound'DeusExSounds.Animal.GrayFootstep'
     GroundSpeed=350.000000
     WaterSpeed=50.000000
     AirSpeed=144.000000
     AccelRate=500.000000
     BaseEyeHeight=44.000000
     Health=200
     ReducedDamageType=Radiation
     ReducedDamagePct=1.000000
     UnderWaterTime=20.000000
     AttitudeToPlayer=ATTITUDE_Ignore
     HitSound1=Sound'DeusExSounds.Animal.GrayPainSmall'
     HitSound2=Sound'DeusExSounds.Animal.GrayPainLarge'
     Die=Sound'DeusExSounds.Animal.GrayDeath'
     Alliance=GameSpy
     DrawScale=0.800000
     DrawType=DT_Mesh
     Mesh=LodMesh'DeusExCharacters.Gray'
     MultiSkins(0)=Texture'tnmcharacters.Skins.PhaserTex0'
     SoundRadius=14
     SoundVolume=255
     CollisionHeight=32.000000
     CollisionRadius=25.000000
     Mass=100.000000
     Buoyancy=97.000000
     BarkBindName="Phaser"
     BindName="Phaser"
     FamiliarName="Alien Phaser"
     UnfamiliarName="Alien Phaser"
}
