//=============================================================================
// SD.
//=============================================================================
class SD extends TNMAggressive;

var() float FireballFrequency;
var float firecounter;

//Copied from animal.uc
function PlayRunningAndFiring() {}
function TweenToShoot(float tweentime) {}
function PlayShoot() {}
function TweenToAttack(float tweentime) {}
function PlayAttack() {}
function PlaySittingDown() {}
function PlaySitting() {}
function PlayStandingUp() {}
function PlayRubbingEyesStart() {}
function PlayRubbingEyes() {}
function PlayRubbingEyesEnd() {}
function PlayStunned() {}
function PlayFalling() {}
function PlayLanded(float impactVel) {}
function PlayDuck() {}
function PlayRising() {}
function PlayCrawling() {}
function PlayPushing() {}
function PlayFiring() {}
function PlayTakingHit(EHitLocation hitPos) {}
function PlayCowerBegin() {}
function PlayCowering() {}
function PlayCowerEnd() {}


// SD is immune to fire and gas and knockout
function bool FilterDamageType(Pawn instigatedBy, Vector hitLocation,
                               Vector offset, Name damageType)
{
	if ((damageType == 'TearGas') || (damageType == 'HalonGas') || (damageType == 'PoisonGas') || (damageType == 'Flamed') || (damageType == 'Burned') ||
	    (damageType == 'Stunned') || (damageType == 'KnockedOut') || (damageType == 'headstun') || (damageType == 'Poison') || (damageType == 'PoisonEffect'))
		return false;
	else
		return Super.FilterDamageType(instigatedBy, hitLocation, offset, damageType);
}

function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if (!bCollideActors && !bBlockActors && !bBlockPlayers)
		return;
	else if ((damageType == 'TearGas') || (damageType == 'HalonGas'))
		GotoNextState();
	else if (damageType == 'Stunned')
		GotoNextState();
	else if (CanShowPain())
		TakeHit(hitPos);
	else
		GotoNextState();
}

//This should ensure that you output the same number of fireballs regardless of your tick frequency
//however the greater your tick frequency the more regular the stream will be.
function FireFlames(float deltatime)
{
	local int i;
	local int fireballs;
	local tnmfireball t;
	local vector Start;
	local vector x,y,z;
	local rotator rot;

	firecounter += deltatime;
	fireballs = (FireballFrequency) * firecounter;

	GetAxes(ViewRotation,X,Y,Z);
	Start = Location + 80 * X + 20 * Z; 
	rot = rotation; 
	rot.pitch = viewrotation.pitch;
	
	for ( i = 0 ; i < fireballs; i++)
	{
		Spawn(Class'tnmfireball', self,, Start + 2 * vrand() + X * 30 * i / fireballs, rotation);	
	}
	firecounter = firecounter % (1/ FireballFrequency);
}

simulated function tick(float deltatime)
{
	super.tick(deltatime);

	if ( AnimSequence == 'Attack' )
	{
		if (( AnimFrame > 0.3 ) && (AnimFrame < 0.7))
		{
			FireFlames(deltaTime);		
		}
	}
}

// Import sounds
#exec AUDIO IMPORT FILE="Sounds\SDFootstep.wav"		NAME="SDFootstep" 	GROUP="Animal"
#exec AUDIO IMPORT FILE="Sounds\SDPainSmall.wav"	NAME="SDPainSmall" 	GROUP="Animal"
#exec AUDIO IMPORT FILE="Sounds\SDPainLarge.wav"	NAME="SDPainLarge" 	GROUP="Animal"
#exec AUDIO IMPORT FILE="Sounds\SDDeath.wav"		NAME="SDDeath" 		GROUP="Animal"

defaultproperties
{
     FireballFrequency=100
     CarcassType=Class'tnmcharacters.SDCarcass'
     WalkingSpeed=0.320000
     bCanBleed=True
     bCanStrafe=False
     ShadowScale=2.000000
     InitialAlliances(0)=(AllianceName="Llama",AllianceLevel=1.000000)
     InitialAlliances(1)=(AllianceName="Goat",AllianceLevel=-1.000000,bPermanent=True)
     InitialAlliances(2)=(AllianceName="WC",AllianceLevel=-1.000000,bPermanent=True)
     InitialInventory(0)=(Inventory=Class'WeaponFlameBreath')
     InitialInventory(1)=(Inventory=Class'DeusEx.AmmoGreaselSpit',Count=9999)
     bCanGlide=False
     GroundSpeed=350.000000
     AirSpeed=144.000000
     BaseEyeHeight=124.000000
     MaxProvocations=1
     WalkSound=Sound'TNMCharacters.Animal.SDFootstep'
     HitSound1=Sound'TNMCharacters.Animal.SDPainSmall'
     HitSound2=Sound'TNMCharacters.Animal.SDPainLarge'
     Die=Sound'TNMCharacters.Animal.SDDeath'
     Health=300
     HealthHead=600
     HealthTorso=300
     HealthLegLeft=300
     HealthLegRight=300
     HealthArmLeft=300
     HealthArmRight=300
     Mesh=LodMesh'DeusExCharacters.Greasel'
     DrawScale=4.000000
     MultiSkins(0)=Texture'tnmcharacters.Skins.SDTex'
     CollisionRadius=80.000000
     CollisionHeight=72.000000
     Mass=2000.000000
     Buoyancy=100.000000
     BindName="Silver"
     BarkBindName="Silver"
     FamiliarName="Silver Dragon"
     UnfamiliarName="Huge Scary Dragon"
     bCanTurnHead=false
}
