//based off of TNMFire
class TNMPhaseEffect extends Effects;

simulated function Tick(float deltaTime)
{
	Super.Tick(deltaTime);

	// if our owner or base is destroyed, destroy us
	if (Owner == None)
		Destroy();
}

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

	Mesh = Owner.Mesh;
	DrawScale = Owner.DrawScale*0.5;
//	PrePivot += vect(0,0,20);

	bTrailerSameRotation = true;
	bAnimByOwner = true;

	SetBase(Owner);
}

defaultproperties
{
     bTravel=True
     Physics=PHYS_Trailer
     DrawType=DT_Mesh
     Style=STY_Translucent
     Texture=FireTexture'Effects.Electricity.RadAttack'
     bUnlit=True
     bParticles=True
     bOwnerNoSee=True
}