//=============================================================================
//
// TNM_Medbot.
//
// same as default medbot, except it opens the new medbot aug screen
//
//=============================================================================
class TNM_Medbot extends MedicalBot;

var localized string rechargemessage;

function Frob(Actor Frobber, Inventory frobWith)
{
   local DeusExPlayer player;
	local DeusExRootWindow root;
	local HUDMedBotAddAugsScreen winAug;
	local HUDMedBotHealthScreen  winHealth;
	local AugmentationCannister augCan;

   Super.Frob(Frobber, frobWith);
   
   player = DeusExPlayer(Frobber);

   if (player == None)
      return;
   
   // DEUS_EX AMSD  In multiplayer, don't pop up the window, just use them
   // In singleplayer, do the old thing.  
   if (Level.NetMode == NM_Standalone)
   {		
      root = DeusExRootWindow(player.rootWindow);
      if (root != None)
      {
         // First check to see if the player has any augmentation cannisters.
         // If so, then we'll pull up the Add Augmentations screen.  
         // Otherwise pull up the Health screen first.
         
         augCan = AugmentationCannister(player.FindInventoryType(Class'AugmentationCannister'));
         
         if (augCan != None)
         {
            // Smoke39 - out with the old, in with the new
            winAug = HUDMedBotAddAugsScreen(root.InvokeUIScreen(Class'TNM_MedbotAugScreen', True));
            winAug.SetMedicalBot(Self, True);
         }
         else
         {
            winHealth = HUDMedBotHealthScreen(root.InvokeUIScreen(Class'HUDMedBotHealthScreen', True));
            winHealth.SetMedicalBot(Self, True);
         }
         root.MaskBackground(True);
      }
   }
   else
   {
      if (CanHeal())
      {
			if ( Level.NetMode != NM_Standalone )
			{
				PlaySound(sound'MedicalHiss', SLOT_None,,, 256);
				if ( Frobber.IsA('DeusExPlayer') )
				{
					DeusExPlayer(Frobber).StopPoison();
					DeusExPlayer(Frobber).ExtinguishFire();
					DeusExPlayer(Frobber).drugEffectTimer = 0;
				}
			}
         HealPlayer(DeusExPlayer(Frobber));
      }
      else
      {
         Pawn(Frobber).ClientMessage(sprintf(rechargemessage,int(healRefreshTime - (Level.TimeSeconds - lastHealTime))));
      }
   }   
}

defaultproperties
{
     rechargemessage="Medbot still charging, %s seconds to go."
}
