//=============================================================================
// WeaponTNMRobotGun.
//=============================================================================
class WeaponTNMRobotGun extends WeaponNPCRanged;

// Import sounds
#exec AUDIO IMPORT FILE="Sounds\MilbotReload.wav"	NAME="MilbotReload" 	GROUP="Weapons"

simulated function Vector ComputeProjectileStart(Vector X, Vector Y, Vector Z)
{
	return Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
}


// fire weapons out of alternating sides
function Fire(float Value)
{
	PlayerViewOffset.Y = -PlayerViewOffset.Y;
	Super.Fire(Value);
}

simulated function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X, Y, Z;
	local Rotator rot;
	local actor Other;
	local float dist, alpha, degrade;
	local int i, numSlugs;
	local float volume, radius;
	local actor shell;

	// make noise if we are not silenced
	if (!bHasSilencer && !bHandToHand)
	{
		GetAIVolume(volume, radius);
		Owner.AISendEvent('WeaponFire', EAITYPE_Audio, volume, radius);
		Owner.AISendEvent('LoudNoise', EAITYPE_Audio, volume, radius);
		if (!Owner.IsA('PlayerPawn'))
			Owner.AISendEvent('Distress', EAITYPE_Audio, volume, radius);
	}

	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = ComputeProjectileStart(X, Y, Z);
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);

	numSlugs = 1;

      EndTrace = StartTrace + Accuracy * (FRand()-0.5)*Y*1000 + Accuracy * (FRand()-0.5)*Z*1000 ;
      EndTrace += (FMax(1024.0, MaxRange) * vector(AdjustedAim));
      
      Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

		// randomly draw a tracer for relevant ammo types
//		if (FRand() < 0.5)
//		{
			rot = Rotator(EndTrace - StartTrace);
			if (VSize(HitLocation - StartTrace) > 250)
			{
				Spawn(class'Tracer',,, StartTrace + 96 * Vector(rot), rot);
			}

			shell = spawn(class'ShellCasing',,, StartTrace /*+ 96 * Vector(rot)*/, rot);
			if (shell != none)
			{
				shell.Velocity = Vect(0,0,0);
				if ( playerviewoffset.Y > 0 )
					shell.Velocity += Y * 2* (FRand()*20+90);
				else
					shell.velocity += Y * 2* -(FRand()*20+90);
				shell.Velocity += X * (10-FRand()*20);
				//shell.Velocity*=Vector(rot);
			}
//		}



		// check our range
		dist = Abs(VSize(HitLocation - Owner.Location));

		if (dist <= AccurateRange)		// we hit just fine
			ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
		else if (dist <= MaxRange)
		{
			// simulate gravity by lowering the bullet's hit point
			// based on the owner's distance from the ground
			alpha = (dist - AccurateRange) / (MaxRange - AccurateRange);
			degrade = 0.5 * Square(alpha);
			HitLocation.Z += degrade * (Owner.Location.Z - Owner.CollisionHeight);
			ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
		}

	// otherwise we don't hit the target at all
}

defaultproperties
{
     ShotTime=0.100000
     reloadTime=1.000000
     HitDamage=6
     BaseAccuracy=0.600000
     bHasMuzzleFlash=True
     AmmoName=Class'AmmoTNMRobotGun'
     PickupAmmoCount=50
     bInstantHit=True
     FireSound=Sound'DeusExSounds.Robot.RobotFireGun'
     CockingSound=Sound'TNMCharacters.Weapons.MilbotReload'
     SelectSound=Sound'DeusExSounds.Weapons.AssaultGunSelect'
     PlayerViewOffset=(Y=-46.000000,Z=36.000000)
     ItemName="Machine Guns"
}
