//=============================================================================
// Wolfy
//=============================================================================
class Wolfy extends TNMAggressive;

var float time;

function PlayDogBark()
{
	if (FRand() < 0.5)
		PlaySound(sound'DogLargeBark2', SLOT_None);
	else
		PlaySound(sound'DogLargeBark3', SLOT_None);
}

function Tick(float deltaTime)
{
	Super.Tick(deltaTime);

	time += deltaTime;

	// check for random noises
	if (time > 1.0)
	{
		time = 0;
		if (FRand() < 0.05 && !IsInState('Conversation'))
			PlayDogBark();
	}
}

function PlayTakingHit(EHitLocation hitPos)
{
	// nil
}

function PlayAttack()
{
	PlayAnimPivot('Attack');
}

function TweenToAttack(float tweentime)
{
	TweenAnimPivot('Attack', tweentime);
}

function PlayBarking()
{
	PlayAnimPivot('Bark');
}

defaultproperties
{
     CarcassType=Class'tnmcharacters.WolfyCarcass'
     WalkingSpeed=0.200000
     GroundSpeed=250.000000
     WaterSpeed=50.000000
     AirSpeed=144.000000
     BaseEyeHeight=12.500000
     HitSound1=Sound'DeusExSounds.Animal.DogSmallGrowl'
     HitSound2=Sound'DeusExSounds.Animal.DogSmallBark1'
     Die=Sound'DeusExSounds.Animal.DogSmallDie'
     InitialInventory(0)=(Inventory=Class'WeaponTNMDogBite')
     Mesh=LodMesh'DeusExCharacters.Mutt'
     MultiSkins(0)=Texture'tnmcharacters.Skins.Wolfy'
     CollisionRadius=38.000000
     CollisionHeight=26.000000
     Mass=20.000000
     BarkBindName="Wolfy"
     BindName="Wolfy"
     FamiliarName="Wolfy"
     UnfamiliarName="Wolf"
     bCanTurnHead=false
}
