//=============================================================================
// ryanHuman.
//=============================================================================
class ryanHuman expands TNMAggressive
	abstract;

// ----------------------------------------------------------------------
//The chief purpose of this is to give particular characters animation assignments they didn't once have.
// ----------------------------------------------------------------------
// ANIMATION CALLS
// ----------------------------------------------------------------------

// ----------------------------------------------------------------------
// GetSwimPivot()
// ----------------------------------------------------------------------

function vector GetSwimPivot()
{
	// THIS IS A HIDEOUS, UGLY, MASSIVELY EVIL HACK!!!!
	return (vect(0,0,1)*CollisionHeight*0.65);
}


// ----------------------------------------------------------------------
// GetWalkingSpeed()
// ----------------------------------------------------------------------

function float GetWalkingSpeed()
{
	if (Physics == PHYS_Swimming)
		return MaxDesiredSpeed;
	else
		return WalkingSpeed;
}


// ----------------------------------------------------------------------
// PlayTurnHead()
// ----------------------------------------------------------------------

function bool PlayTurnHead(ELookDirection newLookDir, float rate, float tweentime)
{
	if (bCanTurnHead)
	{
		if (Super.PlayTurnHead(newLookDir, rate, tweentime))
		{
			AIAddViewRotation = rot(0,0,0); // default
			switch (newLookDir)
			{
				case LOOK_Left:
					AIAddViewRotation = rot(0,-5461,0);  // 30 degrees left
					break;
				case LOOK_Right:
					AIAddViewRotation = rot(0,5461,0);   // 30 degrees right
					break;
				case LOOK_Up:
					AIAddViewRotation = rot(5461,0,0);   // 30 degrees up
					break;
				case LOOK_Down:
					AIAddViewRotation = rot(-5461,0,0);  // 30 degrees down
					break;

				case LOOK_Forward:
					AIAddViewRotation = rot(0,0,0);      // 0 degrees
					break;
			}
		}
		else
			return false;
	}
	else
		return false;
}


// ----------------------------------------------------------------------
// PlayRunningAndFiring()
// ----------------------------------------------------------------------

function PlayRunningAndFiring()
{
	local DeusExWeapon W;
	local vector       v1, v2;
	local float        dotp;

	bIsWalking = FALSE;

	W = DeusExWeapon(Weapon);

	if (W != None)
	{
		if (Region.Zone.bWaterZone)
		{
			if (W.bHandToHand)
				LoopAnimPivot('Tread',,0.1,,GetSwimPivot());
			else
				LoopAnimPivot('Tread',,0.1,,GetSwimPivot());
		}
		else
		{
			if (W.bHandToHand)
				LoopAnimPivot('Run',runAnimMult,0.1);
			else
			{
				v1 = Normal((Enemy.Location - Location)*vect(1,1,0));
				if (destPoint != None)
					v2 = Normal((destPoint.Location - Location)*vect(1,1,0));
				else
					v2 = Normal((destLoc - Location)*vect(1,1,0));
				dotp = Abs(v1 dot v2);
				if (dotp < 0.70710678)  // running sideways
				{
					if (HasTwoHandedWeapon())
						LoopAnimPivot('Run',runAnimMult,0.1);
					else
						LoopAnimPivot('Run',runAnimMult,0.1);
				}
				else
				{
					if (HasTwoHandedWeapon())
						LoopAnimPivot('Attack',runAnimMult,0.1);
					else
						LoopAnimPivot('Attack',runAnimMult,0.1);
				}
			}
		}
	}
}


// ----------------------------------------------------------------------
// PlayReloadBegin()
// ----------------------------------------------------------------------

function PlayReloadBegin()
{
	PlayAnimPivot('hittorso',, 0.3);
}


// ----------------------------------------------------------------------
// PlayReload()
// ----------------------------------------------------------------------

function PlayReload()
{
	LoopAnimPivot('hittorso',, 0.3);
}


// ----------------------------------------------------------------------
// PlayReloadEnd()
// ----------------------------------------------------------------------

function PlayReloadEnd()
{
	PlayAnimPivot('hittorso',, 0.3);
}


// ----------------------------------------------------------------------
// TweenToShoot()
// ----------------------------------------------------------------------

function TweenToShoot(float tweentime)
{
	if (Region.Zone.bWaterZone)
		TweenAnimPivot('Attack', tweentime, GetSwimPivot());
	else if (!bCrouching)
	{
		if (!IsWeaponReloading())
		{
			if (HasTwoHandedWeapon())
				TweenAnimPivot('Attack', tweentime);
			else
				TweenAnimPivot('Attack', tweentime);
		}
		else
			PlayReload();
	}
}


// ----------------------------------------------------------------------
// PlayShoot()
// ----------------------------------------------------------------------

function PlayShoot()
{
	if (Region.Zone.bWaterZone)
		PlayAnimPivot('Attack', , 0, GetSwimPivot());
	else
	{
		if (HasTwoHandedWeapon())
			PlayAnimPivot('Attack', , 0);
		else
			PlayAnimPivot('Attack', , 0);
	}
}


// ----------------------------------------------------------------------
// TweenToCrouchShoot()
// ----------------------------------------------------------------------

function TweenToCrouchShoot(float tweentime)
{
	if (Region.Zone.bWaterZone)
		TweenAnimPivot('Attack', tweentime, GetSwimPivot());
	else
		TweenAnimPivot('Crouch', tweentime);
}


// ----------------------------------------------------------------------
// PlayCrouchShoot()
// ----------------------------------------------------------------------

function PlayCrouchShoot()
{
	if (Region.Zone.bWaterZone)
		PlayAnimPivot('Attack', , 0, GetSwimPivot());
	else
		PlayAnimPivot('Crouch', , 0);
}


// ----------------------------------------------------------------------
// TweenToAttack()
// ----------------------------------------------------------------------

function TweenToAttack(float tweentime)
{
	if (Region.Zone.bWaterZone)
		TweenAnimPivot('Tread', tweentime, GetSwimPivot());
	else
	{
		if (bUseSecondaryAttack)
			TweenAnimPivot('AttackSide', tweentime);
		else
			TweenAnimPivot('Attack', tweentime);
	}
}


// ----------------------------------------------------------------------
// PlayAttack()
// ----------------------------------------------------------------------

function PlayAttack()
{
	if (Region.Zone.bWaterZone)
		PlayAnimPivot('Tread',,,GetSwimPivot());
	else
	{
		if (bUseSecondaryAttack)
			PlayAnimPivot('AttackSide');
		else
			PlayAnimPivot('Attack');
	}
}


// ----------------------------------------------------------------------
// PlayTurning()
// ----------------------------------------------------------------------

function PlayTurning()
{
//	ClientMessage("PlayTurning()");
	if (Region.Zone.bWaterZone)
		LoopAnimPivot('Tread', , , , GetSwimPivot());
	else
	{
		if (HasTwoHandedWeapon())
			TweenAnimPivot('Walk', 0.1);
		else
			TweenAnimPivot('Walk', 0.1);
	}
}


// ----------------------------------------------------------------------
// TweenToWalking()
// ----------------------------------------------------------------------

function TweenToWalking(float tweentime)
{
//	ClientMessage("TweenToWalking()");
	bIsWalking = True;
	if (Region.Zone.bWaterZone)
		TweenAnimPivot('Tread', tweentime, GetSwimPivot());
	else
	{
		if (HasTwoHandedWeapon())
			TweenAnimPivot('Walk', tweentime);
		else
			TweenAnimPivot('Walk', tweentime);
	}
}


// ----------------------------------------------------------------------
// PlayWalking()
// ----------------------------------------------------------------------

function PlayWalking()
{
//	ClientMessage("PlayWalking()");
	bIsWalking = True;
	if (Region.Zone.bWaterZone)
		LoopAnimPivot('Tread', , 0.15, , GetSwimPivot());
	else
	{
		if (HasTwoHandedWeapon())
			LoopAnimPivot('Walk',walkAnimMult, 0.15);
		else
			LoopAnimPivot('Walk',walkAnimMult, 0.15);
	}
}


// ----------------------------------------------------------------------
// TweenToRunning()
// ----------------------------------------------------------------------

function TweenToRunning(float tweentime)
{
//	ClientMessage("TweenToRunning()");
	bIsWalking = False;
	if (Region.Zone.bWaterZone)
		LoopAnimPivot('Tread',, tweentime,, GetSwimPivot());
	else
	{
		if (HasTwoHandedWeapon())
			LoopAnimPivot('Attack', runAnimMult, tweentime);
		else
			LoopAnimPivot('Run', runAnimMult, tweentime);
	}
}


// ----------------------------------------------------------------------
// PlayRunning()
// ----------------------------------------------------------------------

function PlayRunning()
{
//	ClientMessage("PlayRunning()");
	bIsWalking = False;
	if (Region.Zone.bWaterZone)
		LoopAnimPivot('Tread',,,,GetSwimPivot());
	else
	{
		if (HasTwoHandedWeapon())
			LoopAnimPivot('Attack', runAnimMult);
		else
			LoopAnimPivot('Run', runAnimMult);
	}
}


// ----------------------------------------------------------------------
// PlayPanicRunning()
// ----------------------------------------------------------------------

function PlayPanicRunning()
{
//	ClientMessage("PlayPanicRunning()");
	bIsWalking = False;
	if (Region.Zone.bWaterZone)
		LoopAnimPivot('Tread',,,,GetSwimPivot());
	else
		LoopAnimPivot('Panic', runAnimMult);
}


// ----------------------------------------------------------------------
// TweenToWaiting()
// ----------------------------------------------------------------------

function TweenToWaiting(float tweentime)
{
//	ClientMessage("TweenToWaiting()");
	if (Region.Zone.bWaterZone)
		TweenAnimPivot('Tread', tweentime, GetSwimPivot());
	else
	{
		if (HasTwoHandedWeapon())
			TweenAnimPivot('BreatheLight', tweentime);
		else
			TweenAnimPivot('BreatheLight', tweentime);
	}
}


// ----------------------------------------------------------------------
// PlayWaiting()
// ----------------------------------------------------------------------

function PlayWaiting()
{
//	ClientMessage("PlayWaiting()");
	if (Region.Zone.bWaterZone)
		LoopAnimPivot('Tread', , 0.3, , GetSwimPivot());
	else
	{
		if (HasTwoHandedWeapon())
			LoopAnimPivot('BreatheLight', , 0.3);
		else
			LoopAnimPivot('BreatheLight', , 0.3);
	}
}


// ----------------------------------------------------------------------
// PlayIdle()
// ----------------------------------------------------------------------

function PlayIdle()
{
//	ClientMessage("PlayIdle()");
	if (Region.Zone.bWaterZone)
		LoopAnimPivot('Tread', , 0.3, , GetSwimPivot());
	else
	{
		if (HasTwoHandedWeapon())
			PlayAnimPivot('Idle1', , 0.3);
		else
			PlayAnimPivot('Idle1', , 0.3);
	}
}


// ----------------------------------------------------------------------
// PlayDancing()
// ----------------------------------------------------------------------

function PlayDancing()
{
//	ClientMessage("PlayDancing()");
	if (Region.Zone.bWaterZone)
		LoopAnimPivot('Tread', , 0.3, , GetSwimPivot());
	else
		LoopAnimPivot('Dance', FRand()*0.2+0.9, 0.3);
}


// ----------------------------------------------------------------------
// PlaySittingDown()
// ----------------------------------------------------------------------

function PlaySittingDown()
{
//	ClientMessage("PlaySittingDown()");
	PlayAnimPivot('Crouch', , 0.15);
}


// ----------------------------------------------------------------------
// PlaySitting()
// ----------------------------------------------------------------------

function PlaySitting()
{
//	ClientMessage("PlaySitting()");
	LoopAnimPivot('Crouch', , 0.15);
}


// ----------------------------------------------------------------------
// PlayStandingUp()
// ----------------------------------------------------------------------

function PlayStandingUp()
{
//	ClientMessage("PlayStandingUp()");
	PlayAnimPivot('Stand', , 0.15);
}


// ----------------------------------------------------------------------
// PlayRubbingEyesStart()
// ----------------------------------------------------------------------

function PlayRubbingEyesStart()
{
//	ClientMessage("PlayRubbingEyesStart()");
	PlayAnimPivot('RubEyesStart', , 0.15);
}


// ----------------------------------------------------------------------
// PlayRubbingEyes()
// ----------------------------------------------------------------------

function PlayRubbingEyes()
{
//	ClientMessage("PlayRubbingEyes()");
	LoopAnimPivot('RubEyes');
}


// ----------------------------------------------------------------------
// PlayRubbingEyesEnd()
// ----------------------------------------------------------------------

function PlayRubbingEyesEnd()
{
//	ClientMessage("PlayRubbingEyesEnd()");
	PlayAnimPivot('RubEyesStop');
}


// ----------------------------------------------------------------------
// PlayCowerBegin()
// ----------------------------------------------------------------------

function PlayCowerBegin()
{
//	ClientMessage("PlayCowerBegin()");
	if (Region.Zone.bWaterZone)
		LoopAnimPivot('Tread',,,,GetSwimPivot());
	else
		PlayAnimPivot('CowerBegin');
}


// ----------------------------------------------------------------------
// PlayCowering()
// ----------------------------------------------------------------------

function PlayCowering()
{
//	ClientMessage("PlayCowering()");
	if (Region.Zone.bWaterZone)
		LoopAnimPivot('Tread',,,,GetSwimPivot());
	else
		LoopAnimPivot('CowerStill');
}


// ----------------------------------------------------------------------
// PlayCowerEnd()
// ----------------------------------------------------------------------

function PlayCowerEnd()
{
//	ClientMessage("PlayCowerEnd()");
	if (Region.Zone.bWaterZone)
		LoopAnimPivot('Tread',,,,GetSwimPivot());
	else
		PlayAnimPivot('CowerEnd');
}


// ----------------------------------------------------------------------
// PlayStunned()
// ----------------------------------------------------------------------

function PlayStunned()
{
//	ClientMessage("PlayStunned()");
	LoopAnimPivot('Shocked');
}


// ----------------------------------------------------------------------
// TweenToSwimming()
// ----------------------------------------------------------------------

function TweenToSwimming(float tweentime)
{
//	ClientMessage("TweenToSwimming()");
	TweenAnimPivot('Tread', tweentime, GetSwimPivot());
}


// ----------------------------------------------------------------------
// PlaySwimming()
// ----------------------------------------------------------------------

function PlaySwimming()
{
//	ClientMessage("PlaySwimming()");
	LoopAnimPivot('Tread', , , , GetSwimPivot());
}


// ----------------------------------------------------------------------
// PlayFalling()
// ----------------------------------------------------------------------

function PlayFalling()
{
//	ClientMessage("PlayFalling()");
	PlayAnimPivot('Jump', 3, 0.1);
}


// ----------------------------------------------------------------------
// PlayLanded()
// ----------------------------------------------------------------------

function PlayLanded(float impactVel)
{
//	ClientMessage("PlayLanded()");
	bIsWalking = True;
	if (impactVel < -12*CollisionHeight)
		PlayAnimPivot('Land');
}


// ----------------------------------------------------------------------
// PlayDuck()
// ----------------------------------------------------------------------

function PlayDuck()
{
//	ClientMessage("PlayDuck()");
	TweenAnimPivot('CrouchWalk', 0.25);
//	PlayAnimPivot('Crouch');
}


// ----------------------------------------------------------------------
// PlayRising()
// ----------------------------------------------------------------------

function PlayRising()
{
//	ClientMessage("PlayRising()");
	PlayAnimPivot('Stand');
}


// ----------------------------------------------------------------------
// PlayCrawling()
// ----------------------------------------------------------------------

function PlayCrawling()
{
//	ClientMessage("PlayCrawling()");
	LoopAnimPivot('Crouch');
}


// ----------------------------------------------------------------------
// PlayPushing()
// ----------------------------------------------------------------------

function PlayPushing()
{
//	ClientMessage("PlayPushing()");
	PlayAnimPivot('PushButton', , 0.15);
}


// ----------------------------------------------------------------------
// PlayBeginAttack()
// ----------------------------------------------------------------------

function bool PlayBeginAttack()
{
	return false;
}


// ----------------------------------------------------------------------
// PlayFiring()
// ----------------------------------------------------------------------

/*
function PlayFiring()
{
	local DeusExWeapon W;

//	ClientMessage("PlayFiring()");

	W = DeusExWeapon(Weapon);

	if (W != None)
	{
		if (W.bHandToHand)
		{
			PlayAnimPivot('Attack',,0.1);
		}
		else
		{
			if (W.bAutomatic)
			{
				if (HasTwoHandedWeapon())
					LoopAnimPivot('Attack',,0.1);
				else
					LoopAnimPivot('Attack',,0.1);
			}
			else
			{
				if (HasTwoHandedWeapon())
					PlayAnimPivot('Attack',,0.1);
				else
					PlayAnimPivot('Attack',,0.1);
			}
		}
	}
}
*/


// ----------------------------------------------------------------------
// PlayTakingHit()
// ----------------------------------------------------------------------

function PlayTakingHit(EHitLocation hitPos)
{
	local vector pivot;
	local name   animName;

	animName = '';
	if (!Region.Zone.bWaterZone)
	{
		switch (hitPos)
		{
			case HITLOC_HeadFront:
				animName = 'HitHead';
				break;
			case HITLOC_TorsoFront:
				animName = 'HitTorso';
				break;
			case HITLOC_LeftArmFront:
				animName = 'HitArmLeft';
				break;
			case HITLOC_RightArmFront:
				animName = 'HitArmRight';
				break;

			case HITLOC_HeadBack:
				animName = 'HitHeadBack';
				break;
			case HITLOC_TorsoBack:
			case HITLOC_LeftArmBack:
			case HITLOC_RightArmBack:
				animName = 'HitTorsoBack';
				break;

			case HITLOC_LeftLegFront:
			case HITLOC_LeftLegBack:
				animName = 'HitLegLeft';
				break;

			case HITLOC_RightLegFront:
			case HITLOC_RightLegBack:
				animName = 'HitLegRight';
				break;
		}
		pivot = vect(0,0,0);
	}
	else
	{
		switch (hitPos)
		{
			case HITLOC_HeadFront:
			case HITLOC_TorsoFront:
			case HITLOC_LeftLegFront:
			case HITLOC_RightLegFront:
			case HITLOC_LeftArmFront:
			case HITLOC_RightArmFront:
				animName = 'WaterHitTorso';
				break;

			case HITLOC_HeadBack:
			case HITLOC_TorsoBack:
			case HITLOC_LeftLegBack:
			case HITLOC_RightLegBack:
			case HITLOC_LeftArmBack:
			case HITLOC_RightArmBack:
				animName = 'WaterHitTorsoBack';
				break;
		}
		pivot = GetSwimPivot();
	}

	if (animName != '')
		PlayAnimPivot(animName, , 0.1, pivot);

}


// ----------------------------------------------------------------------
// PlayWeaponSwitch()
// ----------------------------------------------------------------------

function PlayWeaponSwitch(Weapon newWeapon)
{
//	ClientMessage("PlayWeaponSwitch()");
}


// ----------------------------------------------------------------------
// PlayDying()
// ----------------------------------------------------------------------

function PlayDying(name damageType, vector hitLoc)
{
	local Vector X, Y, Z;
	local float dotp;

//	ClientMessage("PlayDying()");
	if (Region.Zone.bWaterZone)
		PlayAnimPivot('WaterDeath',, 0.1);
	else if (bSitting)  // if sitting, always fall forward
		PlayAnimPivot('DeathFront',, 0.1);
	else
	{
		GetAxes(Rotation, X, Y, Z);
		dotp = (Location - HitLoc) dot X;

		// die from the correct side
		if (dotp < 0.0)		// shot from the front, fall back
			PlayAnimPivot('DeathBack',, 0.1);
		else				// shot from the back, fall front
			PlayAnimPivot('DeathFront',, 0.1);
	}

	// don't scream if we are stunned
	if ((damageType == 'Stunned') || (damageType == 'KnockedOut') ||
	    (damageType == 'Poison') || (damageType == 'PoisonEffect'))
	{
		bStunned = True;
		if (bIsFemale)
			PlaySound(Sound'FemaleUnconscious', SLOT_Pain,,,, RandomPitch());
		else
			PlaySound(Sound'MaleUnconscious', SLOT_Pain,,,, RandomPitch());
	}
	else
	{
		bStunned = False;
		PlayDyingSound();
	}
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
// FIRE ROUTINES
// ----------------------------------------------------------------------

// ----------------------------------------------------------------------
// CatchFire()
// ----------------------------------------------------------------------

function CatchFire()
{
	local Fire f;
	local int i;
	local vector loc;

	if (bOnFire || Region.Zone.bWaterZone || (BurnPeriod <= 0) || bInvincible)
		return;

	bOnFire = True;
	burnTimer = 0;

	EnableCloak(false);

	for (i=0; i<8; i++)
	{
		loc.X = 0.5*CollisionRadius * (1.0-2.0*FRand());
		loc.Y = 0.5*CollisionRadius * (1.0-2.0*FRand());
		loc.Z = 0.6*CollisionHeight * (1.0-2.0*FRand());
		loc += Location;
		f = Spawn(class'Fire', Self,, loc);
		if (f != None)
		{
			f.DrawScale = 0.5*FRand() + 1.0;

			// turn off the sound and lights for all but the first one
			if (i > 0)
			{
				f.AmbientSound = None;
				f.LightType = LT_None;
			}

			// turn on/off extra fire and smoke
			if (FRand() < 0.5)
				f.smokeGen.Destroy();
			if (FRand() < 0.5)
				f.AddFire();
		}
	}

	// set the burn timer
	SetTimer(1.0, True);
}

// ----------------------------------------------------------------------
// ExtinguishFire()
// ----------------------------------------------------------------------

function ExtinguishFire()
{
	local Fire f;

	bOnFire = False;
	burnTimer = 0;
	SetTimer(0, False);

	foreach BasedActors(class'Fire', f)
		f.Destroy();
}

// ----------------------------------------------------------------------
// UpdateFire()
// ----------------------------------------------------------------------

function UpdateFire()
{
	// continually burn and do damage
	HealthTorso -= 5;
	GenerateTotalHealth();
	if (Health <= 0)
	{
		TakeDamage(10, None, Location, vect(0,0,0), 'Burned');
		ExtinguishFire();
	}
}

defaultproperties
{
     Restlessness=0.500000
     Wanderlust=0.500000
     Cowardice=0.500000
     maxRange=4000.000000
     MinHealth=30.000000
     RandomWandering=1.000000
     bAlliancesChanged=True
     Orders=Wandering
     HomeExtent=800.000000
     WalkingSpeed=0.400000
     bCanBleed=True
     ClotPeriod=30.000000
     bShowPain=True
     bCanSit=True
     bLikesNeutral=True
     bUseFirstSeatOnly=True
     bCanConverse=True
     bAvoidAim=True
     AvoidAccuracy=0.400000
     bAvoidHarm=True
     HarmAccuracy=0.800000
     CloseCombatMult=0.300000
     bHateShot=True
     bHateInjury=True
     bReactPresence=True
     bReactProjectiles=True
     bEmitDistress=True
     RaiseAlarm=RAISEALARM_BeforeFleeing
     bMustFaceTarget=True
     FireAngle=360.000000
     MaxProvocations=1
     AgitationSustainTime=30.000000
     AgitationDecayRate=0.050000
     FearSustainTime=25.000000
     FearDecayRate=0.500000
     SurprisePeriod=2.000000
     SightPercentage=0.500000
     bHasShadow=True
     ShadowScale=1.000000
     BaseAssHeight=-26.000000
     EnemyTimeout=4.000000
     bTickVisibleOnly=True
     bInWorld=True
     bHighlight=True
     bHokeyPokey=True
     InitialInventory(0)=(Count=1)
     InitialInventory(1)=(Count=1)
     InitialInventory(2)=(Count=1)
     InitialInventory(3)=(Count=1)
     InitialInventory(4)=(Count=1)
     InitialInventory(5)=(Count=1)
     InitialInventory(6)=(Count=1)
     InitialInventory(7)=(Count=1)
     bSpawnBubbles=True
     bWalkAround=True
     BurnPeriod=30.000000
     DistressTimer=-1.000000
     CloakThreshold=50
     walkAnimMult=0.700000
     runAnimMult=1.000000
     bCanStrafe=True
     bCanWalk=True
     bCanSwim=True
     bCanOpenDoors=True
     bIsHuman=True
     bCanGlide=False
     AirSpeed=320.000000
     AccelRate=200.000000
     JumpZ=120.000000
     MinHitWall=9999999827968.000000
     HearingThreshold=0.150000
     Skill=2.000000
     AIHorizontalFov=160.000000
     AspectRatio=2.300000
     bForceStasis=True
     BindName="ryanHuman"
     FamiliarName="DEFAULT FAMILIAR NAME - REPORT THIS AS A BUG"
     UnfamiliarName="DEFAULT UNFAMILIAR NAME - REPORT THIS AS A BUG"
}
