class tnmCat extends tnmAnimal;

enum ESkinColor
{
	SC_White,
	SC_Brown,
	SC_Orange,
	SC_Black
};

var() ESkinColor SkinColor;
var byte initialfatness;
var float time;

var AttachedCollision ac;

function bool WillTakeStompDamage(Actor stomper)
{
	return false;
} 

function PostPostBeginPlay()
{
	super.PostPostBeginPlay();

//	ac=spawn(class'AttachedCollision',Self);
//	ac.Init(CollisionRadius,25,false,true);

	switch(SkinColor)
	{
	case SC_White:
		Skin=Texture'CatTex1';
		fatness=128;
		break;
	case SC_Brown:
		Skin=Texture'CatTexBrown';
		fatness=128;
		break;
	case SC_Orange:
		Skin=Texture'CatTexOrange';
		fatness=140;
		break;
	case SC_Black:
		Skin=Texture'CatTexBlack';
		fatness=132;
		break;
	}
	initialfatness=fatness;
}

//use initial fatness
function tick(float deltatime)
{
	fat += deltatime;
	if (fat >=0.5)
	{
		fat = 0.0;
		if (fatness > initialfatness)
			fatness -= 1;
	}

	super(scriptedpawn).tick(deltatime);

	if (TNMPAM!=none)
		TNMPAM.activateaugs();

	time += deltaTime;

	// check for random noises
	if (time > 1.0)
	{
		time = 0;
		if (FRand() < 0.05)
			PlaySound(sound'CatPurr', SLOT_None,,, 128);
	}
}

function bool ShouldBeStartled(Pawn startler)
{
	local float speed;
	local float time;
	local float dist;
	local float dist2;
	local bool  bJonasIsComing;

	bJonasIsComing = false;
	if (startler != None)
	{
		speed = VSize(startler.Velocity);
		if (speed >= 20)
		{
			dist = VSize(Location - startler.Location);
			time = dist/speed;
			if (time <= 3.0)
			{
				dist2 = VSize(Location - (startler.Location+startler.Velocity*time));
				if (dist2 < speed*1.5)
					bJonasIsComing = true;
			}
		}
	}

	return bJonasIsComing;
}


state Attacking
{
	function Tick(float deltaSeconds)
	{
		Super.Tick(deltaSeconds);
		if (Enemy != None)
			GotoState('Fleeing');
	}
}

defaultproperties
{
     bPlayDying=True
     bFleeBigPawns=True
     MinHealth=0.000000
     CarcassType=Class'tnmCatCarcass'
     WalkingSpeed=0.111111
     InitialInventory(0)=(Inventory=Class'WeaponTNMCatScratch')
     GroundSpeed=180.000000
     WaterSpeed=50.000000
     AirSpeed=144.000000
     AccelRate=500.000000
     MaxStepHeight=14.000000
     BaseEyeHeight=6.000000
     Health=30
     UnderWaterTime=20.000000
     AttitudeToPlayer=ATTITUDE_Ignore
     HitSound1=Sound'DeusExSounds.Animal.CatHiss'
     HitSound2=Sound'DeusExSounds.Animal.CatHiss'
     Die=Sound'DeusExSounds.Animal.CatDie'
     Alliance=Cat
     DrawType=DT_Mesh
     Mesh=LodMesh'DeusExCharacters.Cat'
     CollisionRadius=17.000000
     CollisionHeight=11.300000
     MaxStepHeight=11.0
     bBlockActors=True
     Mass=10.000000
     Buoyancy=97.000000
     RotationRate=(Yaw=100000)
     BindName="Cat"
     FamiliarName="Cat"
     UnfamiliarName="Cat"
}
