class tnmSpiderBot extends tnmRobot;

var float wait;

function Tick(float deltaTime)
{
	wait+=deltaTime;
	if(wait>=1.0)
	{
		SetAgitation();
		wait=0;
	}
	super.Tick(deltaTime);
}

function SetAgitation()
{
	local ScriptedPawn p;
	foreach AllActors(Class'ScriptedPawn', p)
		if(p.GetAllianceType(Alliance) == Alliance_HOSTILE)
			ChangeAlly(p.Alliance,- 1.0, true);
	super.PostBeginPlay();
}

event BaseChange()
{
	local ScriptedPawn pawn;
	pawn = ScriptedPawn(owner);
	if(pawn!=None)
	{
		SetAlliance(pawn.Alliance);
		SetOrders('Following');
		OrderActor=pawn;
		SetAgitation();
	}
}

defaultproperties
{
     EMPHitPoints=25
     maxRange=1536.000000
     MinRange=100.000000
     WalkingSpeed=1.000000
     bKeepWeaponDrawn=True
     InitialInventory(0)=(Inventory=Class'TNMItems.WeaponSpiderbotMini')
     InitialInventory(1)=(Inventory=Class'DeusEx.AmmoBattery',Count=99)
     WalkSound=Sound'DeusExSounds.Robot.SpiderBot2Walk'
     GroundSpeed=200.000000
     WaterSpeed=50.000000
     AirSpeed=144.000000
     AccelRate=200.000000
     PeripheralVision=-1.000000
     HearingThreshold=0.000000
     Health=10
     UnderWaterTime=20.000000
     AttitudeToPlayer=ATTITUDE_Ignore
     Skill=20.000000
     AIHorizontalFov=360.000000
     DrawType=DT_Mesh
     Mesh=LodMesh'DeusExCharacters.SpiderBot2'
     DrawScale=0.50000
     CollisionRadius=17.000000
     CollisionHeight=7.500000
     Mass=50.000000
     Buoyancy=50.000000
     BindName="MiniSpiderBot"
     FamiliarName="Mini-SpiderBot"
     UnfamiliarName="Mini-SpiderBot"
     Dominatable=False
}
