//=============================================================================
// ABISpaceShip.
//=============================================================================
class ABISpaceShip extends TNMVehicles;

var() name FrobEvent;
var() float EnlargeScale;
var() float EnlargeTime;
var() float ShrinkScale;
var() float ShrinkTime;

var bool bRescaling;
var int trigger_count;
var float StartScale;
var float EndScale;
var float ScaleTime;
var float ScaleTimeStart;

// ----------------------------------------------------------------------
// Frob()
//
// If we are frobbed, trigger our event
// ----------------------------------------------------------------------
function Frob(Actor Frobber, Inventory frobWith)
{
	local Actor A;
	local Pawn P;

	P = Pawn(Frobber);
	Super.Frob(Frobber, frobWith);

	if (FrobEvent != '')
		foreach AllActors(class 'Actor', A, FrobEvent)
			A.Trigger(Self, P);
}

function Rescale(float size, float time)
{
	bRescaling=true;
	StartScale=DrawScale;
	EndScale=size;
	ScaleTimeStart=time;
	ScaleTime=time;
}

function Trigger(Actor Other, Pawn Instigator)
{
	switch(trigger_count++)
	{
	case 0:
		Rescale(EnlargeScale,EnlargeTime);
		break;
	case 1:
		Rescale(ShrinkScale,ShrinkTime);
		break;
	}
}

function Tick(float dt)
{
	super.Tick(dt);

	if(bRescaling)
	{
		ScaleTime-=dt;
		if(ScaleTime<0)
		{
			ScaleTime=0;
			bRescaling=false;
		}

		DrawScale=StartScale+(EndScale-StartScale)*(ScaleTimeStart-ScaleTime)/ScaleTimeStart;
	}
}

#exec MESH IMPORT MESH=ship ANIVFILE=MODELS\ship_a.3d DATAFILE=MODELS\ship_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec mesh ORIGIN MESH=ship X=0 Y=0 Z=0 YAW=64

#exec MESH SEQUENCE MESH=ship SEQ=All  STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=ship SEQ=ship STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=Jship0 FILE=textures\Vehicles\shiptex1.PCX GROUP=Skins // MATERIAL #34
#exec TEXTURE IMPORT NAME=Jship1 FILE=textures\Vehicles\shiptex2.PCX GROUP=Skins // MATERIAL #25
#exec TEXTURE IMPORT NAME=Jship2 FILE=textures\Vehicles\shiptex3.PCX GROUP=Skins // MATERIAL #26
#exec TEXTURE IMPORT NAME=Jship3 FILE=textures\Vehicles\shipscreen.PCX GROUP=Skins // MATERIAL #27
#exec TEXTURE IMPORT NAME=Jship4 FILE=textures\Vehicles\exhaust.PCX GROUP=Skins // SCREEN.E


#exec MESHMAP NEW   MESHMAP=ship MESH=ship
#exec MESHMAP SCALE MESHMAP=ship X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=ship NUM=1 TEXTURE=Jship0
#exec MESHMAP SETTEXTURE MESHMAP=ship NUM=2 TEXTURE=Jship1
#exec MESHMAP SETTEXTURE MESHMAP=ship NUM=3 TEXTURE=Jship2
#exec MESHMAP SETTEXTURE MESHMAP=ship NUM=4 TEXTURE=Jship3
#exec MESHMAP SETTEXTURE MESHMAP=ship NUM=5 TEXTURE=Jship4

defaultproperties
{
     ItemName="Space Shuttle"
     Texture=Texture'TNMDeco.Skins.Jship3'
     Mesh=LodMesh'TNMDeco.ship'
     DrawScale=4.000000
     SoundRadius=160
     SoundVolume=192
     AmbientSound=Sound'DeusExSounds.Generic.ElectronicsHum'
     CollisionRadius=110.000000
     CollisionHeight=60.000000
     Mass=6000.000000
     Buoyancy=1000.000000
}
