//=============================================================================
// ArchiveBox.
//=============================================================================
class ArchiveBox extends TNMDecoration;

#exec MESH IMPORT MESH=archivebox ANIVFILE=MODELS\archivebox_a.3d DATAFILE=MODELS\archivebox_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=archivebox X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=archivebox SEQ=All        STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=archivebox SEQ=archivebox STARTFRAME=0 NUMFRAMES=1

// Material #2: Sides and top/bottom:
#exec TEXTURE IMPORT NAME=ArchiveBoxTex0 FILE=TEXTURES\ArchiveBoxTex0.pcx GROUP=Skins
// Material #3: Fronts and backs:
#exec TEXTURE IMPORT NAME=ArchiveBoxTex1 FILE=TEXTURES\ArchiveBoxTex1.PCX GROUP=Skins
#exec TEXTURE IMPORT NAME=ArchiveBoxTex2 FILE=TEXTURES\ArchiveBoxTex2.PCX GROUP=Skins
#exec TEXTURE IMPORT NAME=ArchiveBoxTex3 FILE=TEXTURES\ArchiveBoxTex3.PCX GROUP=Skins
#exec TEXTURE IMPORT NAME=ArchiveBoxTex4 FILE=TEXTURES\ArchiveBoxTex4.PCX GROUP=Skins
#exec TEXTURE IMPORT NAME=ArchiveBoxTex5 FILE=TEXTURES\ArchiveBoxTex5.PCX GROUP=Skins

#exec MESHMAP NEW   MESHMAP=archivebox MESH=archivebox
#exec MESHMAP SCALE MESHMAP=archivebox X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=archivebox NUM=1 TEXTURE=ArchiveBoxTex0
#exec MESHMAP SETTEXTURE MESHMAP=archivebox NUM=2 TEXTURE=ArchiveBoxTex1

event Destroyed()
{
	local Vector loc;
	local Trash trash;
	local int i;

	super.Destroyed();

	// trace down to see if we are sitting on the ground
	loc = vect(0,0,0);
	loc.Z -= CollisionHeight + 8.0;
	loc += Location;

	if (!FastTrace(loc))
	{
		// maybe spawn some paper
		for (i=0; i<8; i++)
		{
			if (i < 4 || FRand() < 0.75)
			{
				loc = Location;
				loc.X += (CollisionRadius / 2) - FRand() * CollisionRadius;
				loc.Y += (CollisionRadius / 2) - FRand() * CollisionRadius;
				loc.Z += (CollisionHeight / 2) + FRand() * CollisionHeight;
				trash = Spawn(class'TrashArchivePaper',,, loc);
				if (trash != None)
				{
					trash.SetPhysics(PHYS_Rolling);
					trash.rot = RotRand(True);
					trash.rot.Yaw = 0;
					trash.dir = VRand() * 20 + vect(20,20,20);
					trash.dir.Z *= 0.2;
					//trash.dir.Z = 0;
				}
			}
		}
	}
}

defaultproperties
{
     HitPoints=10
     FragType=Class'DeusEx.PaperFragment'
     ItemName="Archive Box"
     bBlockSight=True
     DrawType=DT_Mesh
     Mesh=archivebox
     Drawscale=0.2
     CollisionHeight=11.000000
     CollisionRadius=25.000000
     Mass=15.000000
     Buoyancy=30.000000
}
