//=============================================================================
// Ashtray.
//=============================================================================
class Ashtray extends TNMDecoration;

var int FrobCount;

var localized string frobmessage1;
var localized string frobmessage2;
var localized string frobmessage3;
var localized string frobmessage4;
var localized string frobmessage5;

enum ESkinColor
{
	SC_Marble,
	SC_Fency,
	SC_Plain
};

var() ESkinColor SkinColor;

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_Marble:	Skin = Texture'AshtrayTex1'; break;
		case SC_Fency:	Skin = Texture'AshtrayTex2'; break;
		case SC_Plain:	Skin = Texture'AshtrayTex3'; break;
	}
}

#exec MESH IMPORT MESH=Ashtray ANIVFILE=Models\Ashtray_a.3d DATAFILE=Models\Ashtray_d.3d ZEROTEX=1
#exec MESH ORIGIN MESH=Ashtray X=0 Y=0 Z=0
#exec MESHMAP SCALE MESHMAP=Ashtray X=0.00390625 Y=0.00390625 Z=0.00390625
#exec MESH SEQUENCE MESH=Ashtray SEQ=All	STARTFRAME=0	NUMFRAMES=1
#exec MESH SEQUENCE MESH=Ashtray SEQ=Still	STARTFRAME=0	NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=Ashtray MESH=Ashtray

#exec TEXTURE IMPORT NAME=AshtrayTex1 FILE=Textures\Ashtray\Ashtray_a.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=AshtrayTex2 FILE=Textures\Ashtray\Ashtray_b.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=AshtrayTex3 FILE=Textures\Ashtray\Ashtray_c.pcx GROUP="Skins"
#exec MESHMAP SETTEXTURE MESHMAP=Ashtray NUM=0 TEXTURE=AshtrayTex1

function Frob( Actor Frobber, Inventory frobWith )
{
	local DeusExPlayer DXP;

	Super.Frob( Frobber, frobWith );

	DXP = DeusExPlayer( Frobber );
	if ( DXP == None )
		return;

	FrobCount++;
	switch( FrobCount )
	{
		case 5:
			DXP.ClientMessage( frobmessage1 );
			break;
		case 6:
			DXP.ClientMessage( frobmessage2 );
			break;
		case 7:
			DXP.ClientMessage( frobmessage3 );
			break;
		case 8:
			DXP.ClientMessage( frobmessage4 );
			break;
		case 9:
			DXP.ClientMessage( frobmessage5 );
			break;
		default:
	}
}

defaultproperties
{
     HitPoints=10
     ItemName="Public Ashtray"
     Mesh=LodMesh'TNMDeco.Ashtray'
     CollisionRadius=5.500000
     CollisionHeight=20.000000
     Mass=10.000000
     Buoyancy=20.000000
     frobmessage1="You don't smoke."
     frobmessage2="Stop touching this, it's really disgusting."
     frobmessage3="Hoping to find gold in there?"
     frobmessage4="Don't worry, it doesn't appear to be bugged."
     frobmessage5="Yep, definitely no spies hiding down here... carry on."
}
