//=============================================================================
// Bucket.
//=============================================================================
class Bucket extends TNMDecoration;

var int FrobCount;

#exec MESH IMPORT MESH=TNMBucket ANIVFILE=MODELS\TNMBucket_a.3d DATAFILE=MODELS\TNMBucket_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=TNMBucket X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=TNMBucket SEQ=All    STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=TNMBucket SEQ=Bucket STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=JTNMBucket1 FILE=Textures\BucketTex1.PCX GROUP=Skins // BUCKET.D

#exec MESHMAP NEW   MESHMAP=TNMBucket MESH=TNMBucket
#exec MESHMAP SCALE MESHMAP=TNMBucket X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=TNMBucket NUM=1 TEXTURE=JTNMBucket1

var localized string message1;
var localized string message2;
var localized string message3;

function Frob( Actor Frobber, Inventory frobWith )
{
	local DeusExPlayer DXP;

	Super.Frob( Frobber, frobWith );

	DXP = DeusExPlayer( Frobber );
	if ( DXP == None )
		return;

	FrobCount++;
	switch( FrobCount )
	{
		case 5:
			DXP.ClientMessage( message1 );
			break;
		case 6:
			DXP.ClientMessage( message2 );
			break;
		case 7:
			DXP.ClientMessage( message3 );
			break;

		default:
	}
}

defaultproperties
{
     message1="Oops, now you went and poked a hole right through the darn thing."
     message2="And that was my favorite bucket."
     message3="You bastard."
     ItemName="Bucket"
     Mesh=LodMesh'TNMDeco.TNMBucket'
     DrawScale=0.500000
     CollisionRadius=13.500000
     CollisionHeight=14.300000
     Mass=30.000000
     Buoyancy=5.000000
}
