//=============================================================================
// CameraSupport.
//=============================================================================
class CameraSupport extends TNMDecoration;

var SecurityCamera Cam;

function PreBeginPlay()
{
     local Vector v1, v2;
     local class<SecurityCamera> CamClass;
     local Rotator rot;

     Super.PreBeginPlay();

     if (IsA('CameraHold'))
     CamClass = class'TNMCamera';

     rot = Rotation;
     rot.Pitch = 0;
     rot.Roll = 0;
     origRot = rot;
     Cam = Spawn(CamClass, Self,, Location, rot);

     if (Cam != None)
     {
          v1.X = 0;
          v1.Y = 0;
          v1.Z = CollisionHeight + Cam.Default.CollisionHeight;
          v2 = v1 >> Rotation;
          v2 += Location;
          Cam.SetLocation(v2);
          Cam.SetBase(Self);
     }

     // set up the alarm listeners
     AISetEventCallback('Alarm', 'AlarmHeard');

     if ( Level.NetMode != NM_Standalone )
     {
          bInvincible = True;
     }
}

#exec MESH IMPORT MESH=CameraHold ANIVFILE=MODELS\CameraHold_a.3d DATAFILE=MODELS\CameraHold_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=CameraHold X=0 Y=12000 Z=9000 PITCH=128

#exec MESH SEQUENCE MESH=CameraHold SEQ=All        STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=CameraHold SEQ=CameraHold STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JCameraHold1 FILE=Textures\Camera.PCX GROUP=Skins // Material #25

#exec MESHMAP NEW   MESHMAP=CameraHold MESH=CameraHold
#exec MESHMAP SCALE MESHMAP=CameraHold X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=CameraHold NUM=1 TEXTURE=JCameraHold1

defaultproperties
{
     HitPoints=50
     minDamageThreshold=50
     bHighlight=False
     ItemName="CameraSupport"
     bPushable=False
     Physics=PHYS_None
     Mesh=LodMesh'TNMDeco.CameraHold'
     DrawScale=0.300000
     CollisionRadius=14.000000
     CollisionHeight=5.200001
     bCollideActors=False
     bCollideWorld=False
     bBlockActors=False
     Mass=50.000000
     Buoyancy=10.000000
}
