//=============================================================================
// CashRegister.
//=============================================================================
class CashRegister extends ElectronicDevices;

var int FrobCount;

#exec MESH IMPORT MESH=CashRegister ANIVFILE=MODELS\CashRegister_a.3d DATAFILE=MODELS\CashRegister_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH ORIGIN MESH=CashRegister X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=CashRegister SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=CashRegister SEQ=CashRegister STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JCashRegister1 FILE=Textures\CashRegTex1.PCX GROUP=Skins // MATERIAL #2
#exec TEXTURE IMPORT NAME=JCashRegister2 FILE=Textures\CashRegTex2.PCX GROUP=Skins // MATERIAL #3
#exec TEXTURE IMPORT NAME=JCashRegister3 FILE=Textures\CashRegTex3.PCX GROUP=Skins // TOTAL.U
#exec TEXTURE IMPORT NAME=JCashRegister4 FILE=Textures\CashRegTex4.PCX GROUP=Skins // SCREEN.U

#exec MESHMAP NEW   MESHMAP=CashRegister MESH=CashRegister
#exec MESHMAP SCALE MESHMAP=CashRegister X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=CashRegister NUM=1 TEXTURE=JCashRegister1
#exec MESHMAP SETTEXTURE MESHMAP=CashRegister NUM=2 TEXTURE=JCashRegister2
#exec MESHMAP SETTEXTURE MESHMAP=CashRegister NUM=3 TEXTURE=JCashRegister3
#exec MESHMAP SETTEXTURE MESHMAP=CashRegister NUM=4 TEXTURE=JCashRegister4

var localized string message1;
var localized string message2;
var localized string message3;
var localized string message4;
var localized string message5;

function Frob( Actor Frobber, Inventory frobWith )
{
	local DeusExPlayer DXP;

	Super.Frob( Frobber, frobWith );

	DXP = DeusExPlayer( Frobber );
	if ( DXP == None )
		return;

	FrobCount++;
	switch( FrobCount )
	{
		case 5:
			DXP.ClientMessage( message1 );
			break;
		case 6:
			DXP.ClientMessage( message2 );
			break;
		case 7:
			DXP.ClientMessage( message3 );
			break;
		case 8:
			DXP.ClientMessage( message4 );
			break;
		case 9:
			DXP.ClientMessage( message5 );
			break;
		default:
	}
}

defaultproperties
{
     message1="What, you've never seen a cash register before?"
     message2="It's locked, go rob something else."
     message3="Maybe you'll have more luck with an ATM?"
     message4="Pushing random buttons probably won't help you extract any cash from it."
     message5="Do you really have nothing better to do?"
     bInvincible=False
     ItemName="Cash Register"
     Mesh=LodMesh'TNMDeco.CashRegister'
     DrawScale=0.480000
     CollisionRadius=20.000000
     CollisionHeight=19.700001
     Mass=30.000000
     Buoyancy=5.000000
}
