class CrateSSBlowup extends CrateExplosiveSmall;

#EXEC OBJ LOAD FILE=TNMSounds

//always fun to copy and paste functions
//ALWAYS
function Explode(vector HitLocation)
{
	local ShockRing ring;
	local ScorchMark s;
	local ExplosionLight light;
	local int i;
	local trestkon t;

	// make sure we wake up when taking damage
	bStasis = False;

	// alert NPCs that I'm exploding
	AISendEvent('LoudNoise', EAITYPE_Audio, , explosionRadius * 16);

	t = trestkon(GetPlayerPawn());

	switch(rand(5))
	{
	case 0:
		t.PlaySound(Sound'TNMSounds.OneShot.Splode01', SLOT_None, 4.0, true, 65536);
		break;
	case 1:
		t.PlaySound(Sound'TNMSounds.OneShot.Splode02', SLOT_None, 4.0, true, 65536);
		break;
	case 2:
		t.PlaySound(Sound'TNMSounds.OneShot.Splode03', SLOT_None, 4.0, true, 65536);
		break;
	case 3:
		t.PlaySound(Sound'TNMSounds.OneShot.Splode04', SLOT_None, 4.0, true, 65536);
		break;
	case 4:
		t.PlaySound(Sound'TNMSounds.OneShot.Splode05', SLOT_None, 4.0, true, 65536);
		break;
	}

	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, HitLocation);
	if (explosionRadius < 128)
	{
		Spawn(class'ExplosionSmall',,, HitLocation);
		light.size = 2;
	}
	else if (explosionRadius < 256)
	{
		Spawn(class'ExplosionMedium',,, HitLocation);
		light.size = 4;
	}
	else
	{
		Spawn(class'ExplosionLarge',,, HitLocation);
		light.size = 8;
	}

	// draw a pretty shock ring
	ring = Spawn(class'ShockRing',,, HitLocation, rot(16384,0,0));
	if (ring != None)
		ring.size = explosionRadius / 32.0;
	ring = Spawn(class'ShockRing',,, HitLocation, rot(0,0,0));
	if (ring != None)
		ring.size = explosionRadius / 32.0;
	ring = Spawn(class'ShockRing',,, HitLocation, rot(0,16384,0));
	if (ring != None)
		ring.size = explosionRadius / 32.0;

	// spawn a mark
	s = spawn(class'ScorchMark', Base,, Location-vect(0,0,1)*CollisionHeight, Rotation+rot(16384,0,0));
	if (s != None)
	{
		s.DrawScale = FClamp(explosionDamage/30, 0.1, 3.0);
		s.ReattachDecal();
	}

	// spawn some rocks
	for (i=0; i<explosionDamage/30+1; i++)
		if (FRand() < 0.8)
			spawn(class'Rockchip',,,HitLocation);

	GotoState('Exploding');
}