//=============================================================================
// EasterEgg.
//=============================================================================
class EasterEgg extends TNMDecoration;

var() int ID;

//
// Mesh, Third and Pickup.
//
#exec MESH IMPORT MESH=EasterEgg ANIVFILE=MODELS\EasterEgg_a.3d DATAFILE=MODELS\EasterEgg_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=EasterEgg X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=EasterEgg SEQ=All        STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=EasterEgg SEQ=EggOnFloor STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JEasterEgg1 FILE=Textures\Egg.PCX GROUP=Skins // 1 - Default

#exec MESHMAP NEW   MESHMAP=EasterEgg MESH=EasterEgg
#exec MESHMAP SCALE MESHMAP=EasterEgg X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=EasterEgg NUM=1 TEXTURE=JEasterEgg1

var() localized string message;

function Frob(actor player, inventory frobwith)
{
  local trestkon t;
  t = trestkon(player);
  if (t != none)
  {
    t.addegg(ID);
    t.ClientMessage(sprintf(message, ID));
  }
  destroy();
}

function tick(float deltatime)
{
	local trestkon t;
	t = trestkon(getplayerpawn());
	if ( t != none)
		if (t.hasegg(ID))
			Destroy();
}

defaultproperties
{
     message="You have discovered Easter Egg #%i! And there was much rejoicing."
     ItemName="EASTER EGG!"
     bInvincible=True
     bPushable=False
     Texture=Texture'TNMDeco.Skins.JEasterEgg1'
     Mesh=LodMesh'TNMDeco.EasterEgg'
     DrawScale=7.000000
     CollisionRadius=13.000000
     CollisionHeight=11.000000
     Mass=2.000000
     Buoyancy=3.000000
}
