//firestarter
//catches on fire, and lets the fire spread to other firestarters
//is put out by Sprinklers
class FireStarter extends TNMDecoration;

var float BurnTimer;
var float FireTimer;
var bool bOnFire;
var TNMFire fire;
var bool bExtinguish;
var float extinguishTimer;
var() float spreadTime;
var() float spreadRadius;
var() float spreadHeight;
var() name sprinkler;
var() bool bBurnUp;
var() float burnUpTime;

function Trigger( Actor Other, Pawn EventInstigator )
{
	CatchFire();
}

auto state active
{
	function TakeDamage( int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
	{
		if(DamageType == 'HalonGas')
		{
			Extinguish();
			return;
		}

		if(DamageType == 'Burned' || DamageType == 'Flamed' || DamageType == 'Exploded')
		{
			CatchFire();
			return;
		}
//		super.TakeDamage(Damage, EventInstigator, HitLocation, Momentum, DamageType);
	}
}

function CatchFire()
{
	local sprinkler spr;

	if (bOnFire || bExtinguish)
		return;

	bOnFire = True;
	fireTimer=0;

	foreach AllActors(class'Sprinkler',spr,sprinkler)
		spr.SetOff(self);

	fire=Spawn(class'TNMFire', self); //yay for reusable classes
		
}

function Tick(float deltaTime)
{
	local Actor act;
	local sprinkler spr;

	if(bOnFire)
	{
		foreach AllActors(class'Sprinkler',spr,sprinkler)
			spr.SetOff(self);
	}

	if(bOnFire)
	{
		fireTimer+=deltaTime;
		if(fireTimer >= spreadTime)
		{
			foreach AllActors(Class'Actor', act)
			{
//				if(sqrt((Location.X-act.Location.X)**2+(Location.Z-act.Location.Z)**2)<=spreadRadius && abs(act.Location.Y-Location.Y)<=spreadHeight)
				if(VSize(vect(1,1,0)*(Location-act.Location))<=spreadRadius&&VSize(vect(0,0,1)*(Location-act.Location))<=spreadHeight)
					if(!bExtinguish || !act.IsA('FireStarter'))
						act.TakeDamage(5, None, Location, vect(0,0,0), 'Flamed');
			}
			fireTimer=0;
		}

		if(!bExtinguish && bBurnUp)
		{
			burnTimer+=deltaTime;
			if(burnTimer >= burnUpTime)
				Destroy();
		}
	}

	if(bExtinguish)
	{
		extinguishTimer-=deltaTime;
		if(extinguishTimer<0)
		{
			bExtinguish=false;
			fire.Destroy();
		}
	}
}

function Extinguish()
{
	if(!bOnFire)
		return;

	bOnFire=false;
	bExtinguish=true;
	extinguishTimer=2.0+FRand();
	//fire.Destroy();
}

defaultproperties
{
	ItemName="Fire Starter"
	CollisionRadius=47.880001
	CollisionHeight=23.250000
	Mass=100.000000
	Buoyancy=110.000000
	BurnUpTime=7.5
	spreadTime=2.0
	spreadRadius=64.0
	spreadRadius=64.0
	spreadHeight=256.0
	Style=STY_Normal
	DrawType=DT_Mesh
	bCanBeBase=True
	Mesh=archivebox
	Texture=Texture'Engine.S_Actor'
}