//=============================================================================
// FlameTurret.
//=============================================================================
class FlameTurret extends HackableDevices;

var int		team;
var String	titleString;
var float	updateTime;

replication
{
	reliable if (Role==ROLE_Authority)
		team, titleString;
}

function Destroyed()
{
	local FlameTurretBase Fturret;

	Fturret = FlameTurretBase(Owner);
	if (Fturret != None)
	{
		Fturret.Fgun = None;
		Fturret.Destroy();
		SetOwner(None);
	}
	Super.Destroyed();
}

function ResetComputerAlignment()
{
	local FlameTurretBase Fturret;
	local ComputerSecurity TempComp;
	local int ViewIndex;

	Fturret = FlameTurretBase(Owner);

	if (( Level.NetMode != NM_Standalone ) && ( Fturret != None ))
	{
		//Find the associated computer
		foreach AllActors(class'ComputerSecurity',TempComp)
		{
			for (ViewIndex = 0; ViewIndex < ArrayCount(TempComp.Views); ViewIndex++)
			{
				if (TempComp.Views[ViewIndex].turretTag == Fturret.Tag)
				{
					TempComp.Team = -1;
				}
			}
		}
	}
}

function HackAction(Actor Hacker, bool bHacked)
{
   local ComputerSecurity CompOwner;
   local ComputerSecurity TempComp;
   local FlameTurretBase Fturret;
   local SecurityCamera Camera;
   local name CameraTag;
   local int ViewIndex;

	Super.HackAction(Hacker, bHacked);

	Fturret = FlameTurretBase(Owner);
	if (bHacked && (Fturret != None))
	{
      if (Level.NetMode == NM_Standalone)
      {
         if (!Fturret.bDisabled)
         {
            Fturret.UnTrigger(Hacker, Pawn(Hacker));
            Fturret.bDisabled = True;
         }
         else
         {
            Fturret.bDisabled = False;
            Fturret.Trigger(Hacker, Pawn(Hacker));
         }
      }
      else
      {
         //DEUS_EX AMSD Reset the hackstrength afterwards
         if (hackStrength == 0.0)
            hackStrength = 0.6;
         Fturret.bDisabled = True;
         Fturret.Trigger(Hacker,Pawn(Hacker));
         //Find the associated computer.
         foreach AllActors(class'ComputerSecurity',TempComp)
         {
            for (ViewIndex = 0; ViewIndex < ArrayCount(TempComp.Views); ViewIndex++)
            {
               if (TempComp.Views[ViewIndex].turretTag == FTurret.Tag)
               {
                  CompOwner = TempComp;
                  //find associated turret
                  cameratag = TempComp.Views[ViewIndex].cameratag;
                  if (cameratag != '')
                  {
                     foreach AllActors(class'Securitycamera', camera, cameraTag)
                     {
                        break;
                     }
                  }
               }
            }
         }

         if (CompOwner != None)
         {
            if ( (Hacker.IsA('DeusExPlayer')) && (Camera.bActive))
            {
               Camera.HackStrength = 0.6;
               if (Camera.bActive)
                  Camera.UnTrigger(Hacker, Pawn(Hacker));
            }
         }
      }
	}
}

function Tick(float deltaTime)
{
	local FlameTurretBase Fturret;

	Super.Tick(deltaTime);

	// As a client, it was possible for the turret to become irrelevant to you while the gun remained relevant
	if  ((Level.NetMode != NM_Standalone) && (updateTime < Level.Timeseconds))
	{
		updateTime = Level.Timeseconds + 2.0;
		Fturret = FlameTurretBase(Owner);
		if ( Fturret != None )
		{
			if ( team != Fturret.team )
				team = Fturret.team;
			if (!( titleString ~= Fturret.titleString ))
				titleString = Fturret.titleString;
		}
	}
}

function TakeDamage(int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
{
	if (( Level.NetMode != NM_Standalone ) && (EventInstigator.IsA('DeusExPlayer')))
		DeusExPlayer(EventInstigator).ServerConditionalNotifyMsg( DeusExPlayer(EventInstigator).MPMSG_TurretInv );

	Super.TakeDamage(Damage, EventInstigator, HitLocation, Momentum, DamageType);
}

function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( Level.NetMode != NM_Standalone )
	{
		bInvincible = True;
      hackStrength = 0.6;
	}
}

function PostBeginPlay()
{
	local FlameTurretBase Fturret;

	Super.PostBeginPlay();

	Fturret = FlameTurretBase(Owner);

	if (( Level.NetMode != NM_Standalone ) && ( Fturret != None ))
	{
		team = Fturret.team;
		titleString = Fturret.titleString;
	}
}



#exec MESH IMPORT MESH=FlameTurret ANIVFILE=MODELS\FlameTurret_a.3d DATAFILE=MODELS\FlameTurret_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec mesh ORIGIN MESH=FlameTurret X=0 Y=0 Z=4720 YAW=64

#exec MESH SEQUENCE MESH=FlameTurret SEQ=All         STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=FlameTurret SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=JFlameTurret1 FILE=Textures\FTex1.PCX GROUP=Skins // TEX1.F
#exec texture IMPORT NAME=JFlameTurret2 FILE=Textures\FTex2.PCX GROUP=Skins // TEX2
#exec texture IMPORT NAME=JFlameTurret3 FILE=Textures\FTex3.PCX GROUP=Skins // SPHERE.E

#exec MESHMAP NEW   MESHMAP=FlameTurret MESH=FlameTurret
#exec MESHMAP SCALE MESHMAP=FlameTurret X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=FlameTurret NUM=1 TEXTURE=JFlameTurret1
#exec MESHMAP SETTEXTURE MESHMAP=FlameTurret NUM=2 TEXTURE=JFlameTurret2
#exec MESHMAP SETTEXTURE MESHMAP=FlameTurret NUM=3 TEXTURE=JFlameTurret3
#exec MESHMAP SETTEXTURE MESHMAP=FlameTurret NUM=4 TEXTURE=effects.fire.flame_b

defaultproperties
{
     Team=-1
     hackStrength=0.300000
     HitPoints=50
     minDamageThreshold=50
     bInvincible=False
     FragType=Class'DeusEx.MetalFragment'
     ItemName="Autonomous Flame Turret"
     Physics=PHYS_Rotating
     Texture=Texture'TNMDeco.Skins.JFlameTurret3'
     Mesh=LodMesh'TNMDeco.FlameTurret'
     DrawScale=0.650000
     SoundRadius=24
     CollisionRadius=22.500000
     CollisionHeight=9.100000
     LightEffect=LE_NonIncidence
     LightBrightness=255
     LightHue=28
     LightSaturation=160
     LightRadius=2
     bRotateToDesired=True
     Mass=50.000000
     Buoyancy=10.000000
     RotationRate=(Pitch=16384,Yaw=16384)
     bVisionImportant=True
}
