//=============================================================================
// GlassBottle.
//=============================================================================
Class GlassBottle expands TNMDecoration;

var int FrobCount;


#exec MESH IMPORT MESH=GlassBottle ANIVFILE=Models\GlassBottle_a.3d DATAFILE=Models\GlassBottle_d.3d ZEROTEX=1
#exec MESH SEQUENCE MESH=GlassBottle SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GlassBottle SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP SCALE MESHMAP=GlassBottle X=0.00390625 Y=0.00390625 Z=0.00390625
#exec TEXTURE IMPORT NAME=GlassBottleTex1 FILE=Textures\GlassBottle_a.pcx GROUP="Skins"
#exec MESHMAP SETTEXTURE MESHMAP=GlassBottle NUM=0 TEXTURE=GlassBottleTex1

var localized string message1;
var localized string message2;
var localized string message3;
var localized string message4;

function Frob( Actor Frobber, Inventory frobWith )
{
	local DeusExPlayer DXP;

	Super.Frob( Frobber, frobWith );

	DXP = DeusExPlayer( Frobber );
	if ( DXP == None )
		return;

	switch( FrobCount++ )
	{
		case 0:
			DXP.ClientMessage( message1 );
			break;
		case 1:
			DXP.ClientMessage( message2 );
			break;
		case 2:
			DXP.ClientMessage( message3 );
			break;
		case 3:
			DXP.ClientMessage( message4 );
			break;
	}
	FrobCount = FrobCount % 4; //as I recall, uscript lacks a %= operator
}

defaultproperties
{
     message1="Please stop smudging the bottle with your dirty, dirty fingers."
     message2="There is no alcohol in this bottle."
     message3="No, you CANNOT drink the contents."
     message4="Looking for beer? I recommend Fort Garry Pale Ale!"
     HitPoints=10
     FragType=Class'DeusEx.GlassFragment'
     ItemName="Glass Bottle"
     Mesh=LodMesh'TNMDeco.GlassBottle'
     CollisionRadius=4.000000
     CollisionHeight=16.000000
     Mass=5.000000
     Buoyancy=10.000000
     bPushable=false
}
