//=============================================================================
// GoatFountain.
//=============================================================================
class GoatFountain extends TNMDecoration;

#exec OBJ LOAD FILE=TNM_Core_Tex
var bool bFlowing;


function Trigger(Actor Other, Pawn Instigator)
{

    super.trigger(other,instigator);

    if (IsInState('Flowing'))
    {
        PlayAnim('Off');
	GotoState('NotFlowing');
    }
    else
    {
       PlayAnim('On');
       bFlowing = true;
       GotoState('Flowing');
    }
}

auto state Flowing
{
	begin:
		FinishAnim();
		LoopAnim('Flowing');	
}

state NotFlowing
{
}

#exec mesh IMPORT MESH=GoatFountain ANIVFILE=MODELS\GoatFountain_a.3d DATAFILE=MODELS\GoatFountain_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=GoatFountain X=0 Y=0 Z=0

#exec mesh SEQUENCE MESH=GoatFountain SEQ=All          STARTFRAME=0 NUMFRAMES=16
#exec mesh SEQUENCE MESH=GoatFountain SEQ=Still        STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=GoatFountain SEQ=On           STARTFRAME=1 NUMFRAMES=5   RATE=12
#exec mesh SEQUENCE MESH=GoatFountain SEQ=Flowing      STARTFRAME=5 NUMFRAMES=5   RATE=4
#exec mesh SEQUENCE MESH=GoatFountain SEQ=Off          STARTFRAME=10 NUMFRAMES=5  RATE=12


#exec texture IMPORT NAME=JGoatFountain1 FILE=Textures\wingedgoattex.PCX GROUP=Skins // GOAT
#exec texture IMPORT NAME=JGoatFountain2 FILE=Textures\fountstonetex1.PCX GROUP=Skins // BOWL

#exec MESHMAP NEW   MESHMAP=GoatFountain MESH=GoatFountain
#exec MESHMAP SCALE MESHMAP=GoatFountain X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=GoatFountain NUM=1 TEXTURE=JGoatFountain1
#exec MESHMAP SETTEXTURE MESHMAP=GoatFountain NUM=2 TEXTURE=JGoatFountain2
#exec MESHMAP SETTEXTURE MESHMAP=GoatFountain NUM=3 TEXTURE=TNM_Core_Tex.Fntn
#exec MESHMAP SETTEXTURE MESHMAP=GoatFountain NUM=4 TEXTURE=TNM_Core_Tex.CalmMelk

defaultproperties
{
     bInvincible=True
     bPushable=False
     ItemName="Melk Fountain"
     Mesh=LodMesh'TNMDeco.GoatFountain'
     DrawScale=1.500000
     CollisionRadius=30.000000
     CollisionHeight=50.000000
     Mass=200.000000
     Buoyancy=5.000000
}
