class GoldenBeamTrigger extends BeamTrigger;

#exec mesh IMPORT MESH=GoldenBeamTrigger ANIVFILE=Models\GoldenBeamTrigger_a.3d DATAFILE=Models\GoldenBeamTrigger_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=GoldenBeamTrigger X=0 Y=0 Z=0 yaw=64

#exec mesh SEQUENCE MESH=GoldenBeamTrigger SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=GoldenBeamTrigger SEQ=still STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=GoldenBeamTriggertex0 FILE=Textures\GoldenBeamTriggertex0.PCX GROUP=Skins // SKIN
#exec texture IMPORT NAME=GoldenBeamTriggertex1 FILE=Textures\GoldenBeamTriggertex1.PCX GROUP=Skins // SKIN
#exec texture IMPORT NAME=GoldenBeamTriggertex2 FILE=Textures\GoldenBeamTriggertex2.PCX GROUP=Skins // LIGHT.U

#exec MESHMAP new MESHMAP=GoldenBeamTrigger MESH=GoldenBeamTrigger
#exec MESHMAP scale MESHMAP=GoldenBeamTrigger X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=GoldenBeamTrigger NUM=0 TEXTURE=GoldenBeamTriggertex1
#exec MESHMAP SETTEXTURE MESHMAP=GoldenBeamTrigger NUM=1 TEXTURE=LaserSpot1

var float damageAmount;
var Actor victim;
var float hurtTime;

function HurtVictim()
{
	victim.TakeDamage(damageAmount, None, Location, vect(0,0,0), 'Flamed');
}

function BeginAlarm()
{
}

function EndAlarm()
{
}

function Tick(float deltaTime)
{
	local Actor A;
	local AdaptiveArmor armor;
	local bool bTrigger;

	if (emitter != None)
	{
		// if we've been EMP'ed, act confused
		if (bConfused && bIsOn)
		{
			confusionTimer += deltaTime;

			// randomly turn on/off the beam
			if (FRand() > 0.95)
				emitter.TurnOn();
			else
				emitter.TurnOff();

			if (confusionTimer > confusionDuration)
			{
				bConfused = False;
				confusionTimer = 0;
				emitter.TurnOn();
			}

			return;
		}

		emitter.SetLocation(Location);
		emitter.SetRotation(Rotation);


		if ((emitter.HitActor != None))
		{
			if (IsRelevant(emitter.HitActor))
			{
				bTrigger = True;

				if (emitter.HitActor.IsA('DeusExPlayer'))
				{
					// check for adaptive armor - makes the player invisible
					foreach AllActors(class'AdaptiveArmor', armor)
						if ((armor.Owner == emitter.HitActor) && armor.bActive)
						{
							bTrigger = False;
							break;
						}
				}

				if (bTrigger)
				{
					Victim = emitter.HitActor;

					hurtTime -= deltaTime;
					while (hurtTime <= 0)
					{
						hurtTime += 0.25;
						HurtVictim(); 
					}

					// play "beam broken" sound
					PlaySound(sound'Beep2',,,, 1280, 3.0);

					if (!bAlreadyTriggered)
					{
						// only be triggered once?
						if (bTriggerOnceOnly)
							bAlreadyTriggered = True;

						// Trigger event
						if(Event != '')
							foreach AllActors(class 'Actor', A, Event)
								A.Trigger(Self, Pawn(emitter.HitActor));
					}
				}
			}
		}

		LastHitActor = emitter.HitActor;
	}
}


function BeginPlay()
{
	Super.BeginPlay();

	LastHitActor = None;
	if (emitter != None)
		emitter.destroy();
	emitter = Spawn(class'TNMLaserEmitter');

	if (emitter != None)
	{
		TNMLaserEmitter(emitter).SetGoldBeam();
		emitter.TurnOn();
		bIsOn = True;
	}
	else
		bIsOn = False;
}

defaultproperties
{
     DamageAmount=10.000000
     Mesh=LodMesh'TNMDeco.GoldenBeamTrigger'	
}
