//=============================================================================
// HandScanner.
//=============================================================================
class HandScanner extends HackableDevices;

var() localized String AcceptMessage;
var() localized String DenyMessage;
var() name clearanceflag[9];

function accept(pawn hacker)
{
	Hacker.ClientMessage(AcceptMessage);
	MultiSkins[3] = Texture'HSGreenlight';
	SetTimer(0.8, False);
	PlaySound(sound'Beep2');
}

function deny(pawn hacker)
{
	Hacker.ClientMessage(DenyMessage);
	MultiSkins[3] = Texture'HSRedlight';
	PlaySound(sound'Buzz1');
	SetTimer(0.4, False);
}

function HackAction(Actor Hacker, bool bHacked)
{
	local Actor A;
	local int i;
	local deusexplayer player;
	local FlagBase flags;

//	Super.HackAction(Hacker, bHacked);

	Player = DeusExPlayer(GetPlayerPawn());

	if (Player != None)
		flags = Player.FlagBase;

	Log("Hack action triggered");

	//If its hacked
	if (bHacked)
	{
			if (Pawn(Hacker) != None)
			{
				accept(Pawn(Hacker));
				for(i=0;i<4;i++)
				   if (UnTriggerEvent[i] != '')
				      foreach AllActors(class 'Actor', A, UnTriggerEvent[i])
				         A.Trigger(Self, Pawn(Hacker));
				return;
			}
	}

	//otherwise if you have the clearance
	for(i=0;i<9;i++)
	{
		if (flags.GetBool(clearanceflag[i]))
		{
			if (Pawn(Hacker) != None)
			{
				accept(Pawn(Hacker));
				if (Event != '')
				foreach AllActors(class 'Actor', A, Event)
					A.Trigger(Self, Pawn(Hacker));
			}
			return;
		}
	}

	//otherwise you can't get it
	deny(Pawn(Hacker));
}

//The player can't hack if the "if bhacking" crap isn't in here too, I need the timer for the light texture switching.
simulated function Timer()
{
    MultiSkins[3] = Texture'HSWhitelight';

    if (bHacking)
	{
		curTool.PlayUseAnim();

	  TicksSinceLastHack += (Level.TimeSeconds - LastTickTime) * 10;
	  LastTickTime = Level.TimeSeconds;
      //TicksSinceLastHack = TicksSinceLastHack + 1;
      while (TicksSinceLastHack > TicksPerHack)
      {
         numHacks--;
         hackStrength -= 0.01;
         TicksSinceLastHack = TicksSinceLastHack - TicksPerHack;
         hackStrength = FClamp(hackStrength, 0.0, 1.0);
      }

		// did we hack it?
		if (hackStrength ~= 0.0)
		{
			hackStrength = 0.0;
			hackPlayer.ClientMessage(msgMultitoolSuccess);
         // Start reset counter from the time you finish hacking it.
         TimeSinceReset = 0;
			StopHacking();
			HackAction(hackPlayer, True);
		}

		// are we done with this tool?
		else if (numHacks <= 0)
			StopHacking();

		// check to see if we've moved too far away from the device to continue
		else if (hackPlayer.frobTarget != Self)
			StopHacking();

		// check to see if we've put the multitool away
		else if (hackPlayer.inHand != curTool)
			StopHacking();
	}
}

#exec MESH IMPORT MESH=HandScanner ANIVFILE=MODELS\HandScanner_a.3d DATAFILE=MODELS\HandScanner_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH ORIGIN MESH=HandScanner X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=HandScanner STRENGTH=0.25

#exec MESH SEQUENCE MESH=HandScanner SEQ=All         STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=HandScanner SEQ=handscanner STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=JHandScanner1 FILE=Textures\HandScanTex1.PCX GROUP=Skins // MAIN.U
#exec texture IMPORT NAME=JHandScanner2 FILE=Textures\HandScanTex2.PCX GROUP=Skins // MATERIAL #26
#exec texture IMPORT NAME=JHandScanner3 FILE=Textures\HandScanTex3.PCX GROUP=Skins // Alternate texture for Space Station
#exec texture IMPORT NAME=HSWhiteLight FILE=Textures\HSWhiteLight.PCX GROUP=Skins // LIGHT.U
#exec texture IMPORT NAME=HSRedLight FILE=Textures\HSRedLight.PCX GROUP=Skins // LIGHT.U
#exec texture IMPORT NAME=HSGreenLight FILE=Textures\HSGreenLight.PCX GROUP=Skins // LIGHT.U

#exec MESHMAP NEW   MESHMAP=HandScanner MESH=HandScanner
#exec MESHMAP SCALE MESHMAP=HandScanner X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=HandScanner NUM=1 TEXTURE=JHandScanner1
#exec MESHMAP SETTEXTURE MESHMAP=HandScanner NUM=2 TEXTURE=JHandScanner2
#exec MESHMAP SETTEXTURE MESHMAP=HandScanner NUM=3 TEXTURE=HSWhiteLight

defaultproperties
{
     AcceptMessage="Clearance granted"
     DenyMessage="Clearance denied"
     msgNotHacked=""
     ItemName="Hand Print Scanner"
     Mesh=LodMesh'TNMDeco.HandScanner'
     DrawScale=0.400000
     ScaleGlow=200.000000
     SoundRadius=8
     SoundVolume=255
     SoundPitch=96
     AmbientSound=Sound'DeusExSounds.Generic.SecurityL'
     CollisionHeight=7.000000
     CollisionRadius=4.000000
     Mass=30.000000
     Buoyancy=40.000000
}
