//=============================================================================
// HoverCarBlue.
//=============================================================================
class HoverCarBlue extends TNMVehicles;

var() name FrobEvent;

// ----------------------------------------------------------------------
// Frob()
//
// If we are frobbed, trigger our event
// ----------------------------------------------------------------------
function Frob(Actor Frobber, Inventory frobWith)
{
	local Actor A;
	local Pawn P;

	P = Pawn(Frobber);
	Super.Frob(Frobber, frobWith);

	if (FrobEvent != '')
		foreach AllActors(class 'Actor', A, FrobEvent)
			A.Trigger(Self, P);
}

function Trigger(Actor Other, Pawn Instigator)
{
	//super.trigger(other,instigator);
}

function Bump( Actor Other )
{
	if (physics == phys_interpolating)
	{
		Other.KilledBy( none );
		Other.TakeDamage(999999999, none, vect(0,0,0), vect(0,0,0), 'exploded');
	}
}

#exec mesh IMPORT MESH=HoverCar ANIVFILE=MODELS\HoverCar_a.3d DATAFILE=MODELS\HoverCar_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec mesh ORIGIN MESH=HoverCar X=0 Y=0 Z=0 YAW=64

#exec MESH SEQUENCE MESH=HoverCar SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=HoverCar SEQ=HoverCar1 STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=JHoverCar1 FILE=Textures\Vehicles\BlueCarTex1.PCX GROUP=Skins // MATERIAL #2
#exec texture IMPORT NAME=JHoverCar2 FILE=Textures\Vehicles\BlueCarTex2.PCX GROUP=Skins // MATERIAL #3
#exec texture IMPORT NAME=JHoverCar3 FILE=Textures\Vehicles\BlueCarTex3.PCX GROUP=Skins // MATERIAL #4
#exec texture IMPORT NAME=JHoverCar4 FILE=Textures\Vehicles\CarBottomTex.PCX GROUP=Skins // MATERIAL #5

#exec MESHMAP NEW   MESHMAP=HoverCar MESH=HoverCar
#exec MESHMAP SCALE MESHMAP=HoverCar X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=HoverCar NUM=1 TEXTURE=JHoverCar1
#exec MESHMAP SETTEXTURE MESHMAP=HoverCar NUM=2 TEXTURE=JHoverCar2
#exec MESHMAP SETTEXTURE MESHMAP=HoverCar NUM=3 TEXTURE=JHoverCar3
#exec MESHMAP SETTEXTURE MESHMAP=HoverCar NUM=4 TEXTURE=JHoverCar4
#exec MESHMAP SETTEXTURE MESHMAP=HoverCar NUM=5 TEXTURE=Effects.electricity.Nano_SFX_A

defaultproperties
{
     ItemName="Hover Car"
     Mesh=LodMesh'TNMDeco.HoverCar'
     DrawScale=5.000000
     SoundRadius=60
     SoundVolume=192
     CollisionRadius=110.000000
     CollisionHeight=60.000000
     Mass=6000.000000
     Buoyancy=1000.000000
}
